/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.storage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.events.XpEvent;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.features.loot_modifiers.SkillUpTrigger;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_UpdateExperience;
import harmonised.pmmo.storage.Experience;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.TagBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class PmmoSavedData
extends SavedData
implements IDataStorage {
    private static final String NAME = "pmmo";
    private Map<UUID, Map<String, Experience>> xp = new HashMap<UUID, Map<String, Experience>>();
    private Map<UUID, Map<String, Experience>> scheduledXP = new HashMap<UUID, Map<String, Experience>>();
    private static final Codec<Map<UUID, Map<String, Experience>>> XP_CODEC = Codec.unboundedMap(CodecTypes.UUID_CODEC, (Codec)Codec.unboundedMap((Codec)Codec.STRING, Experience.CODEC).xmap(HashMap::new, HashMap::new));
    private static final String XP_KEY = "xp_data";
    private static final String SCHEDULED_KEY = "scheduled_xp";

    @Override
    public long getXp(UUID playerID, String skillName) {
        return ((Map)this.xp.getOrDefault(playerID, new HashMap())).getOrDefault(skillName, new Experience()).getXp();
    }

    @Override
    public void addXp(UUID playerID, String skillName, long change) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(playerID);
        if (player == null) {
            this.scheduledXP.computeIfAbsent(playerID, id -> new HashMap()).merge(skillName, new Experience(change), Experience::merge);
            return;
        }
        XpEvent gainXpEvent = new XpEvent(player, skillName, Core.get(player.level()).getData().getXpMap(playerID).getOrDefault(skillName, new Experience()), change, TagBuilder.start().build());
        if (((XpEvent)NeoForge.EVENT_BUS.post((Event)gainXpEvent)).isCanceled()) {
            return;
        }
        if (this.xp.computeIfAbsent(playerID, i -> new HashMap()).computeIfAbsent(gainXpEvent.skill, s -> new Experience()).addXp(gainXpEvent.amountAwarded)) {
            SkillUpTrigger.SKILL_UP.trigger(player);
            Core.get(LogicalSide.SERVER).getPerkRegistry().executePerk(EventType.SKILL_UP, (Player)player, TagBuilder.start().withString("firework_skill", skillName).build());
        }
        this.setDirty();
        Networking.sendToClient(new CP_UpdateExperience(skillName, this.xp.get(playerID).get(skillName), gainXpEvent.amountAwarded), player);
    }

    @Override
    public void setXp(UUID playerID, String skillName, long value) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(playerID);
        if (this.xp.computeIfAbsent(playerID, i -> new HashMap()).computeIfAbsent(skillName, s -> new Experience()).setXp(value) && player != null) {
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.XP, "Skill Update Packet sent to Client" + playerID.toString(), new Object[0]);
            SkillUpTrigger.SKILL_UP.trigger(player);
            Core.get(LogicalSide.SERVER).getPerkRegistry().executePerk(EventType.SKILL_UP, (Player)player, TagBuilder.start().withString("firework_skill", skillName).build());
        }
        this.setDirty();
        if (player != null) {
            Networking.sendToClient(new CP_UpdateExperience(skillName, this.xp.get(playerID).get(skillName), 0L), player);
        }
    }

    @Override
    public Map<String, Experience> getXpMap(UUID playerID) {
        return this.xp.getOrDefault(playerID, new HashMap());
    }

    @Override
    public void setXpMap(UUID playerID, Map<String, Experience> map) {
        this.xp.put(playerID, map != null ? map : new HashMap());
        this.setDirty();
    }

    @Override
    public long getLevel(String skill, UUID player) {
        long rawLevel = Core.get(LogicalSide.SERVER).getLevelProvider().process(skill, this.getXpMap(player).getOrDefault(skill, new Experience()).getLevel().getLevel());
        long skillMaxLevel = Config.skills().get(skill).getMaxLevel();
        return Math.min(rawLevel, skillMaxLevel);
    }

    @Override
    public void setLevel(String skill, UUID playerID, long level) {
        this.xp.computeIfAbsent(playerID, p -> new HashMap()).computeIfAbsent(skill, s -> new Experience()).setLevel(level > 0L ? level : 0L);
        this.setDirty();
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(playerID);
        if (player != null) {
            Networking.sendToClient(new CP_UpdateExperience(skill, this.xp.get(playerID).get(skill), 0L), player);
        }
    }

    @Override
    public void addLevel(String skill, UUID playerID, long change) {
        this.xp.computeIfAbsent(playerID, p -> new HashMap()).computeIfAbsent(skill, s -> new Experience()).addLevel(change);
        this.setDirty();
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(playerID);
        if (player != null) {
            if (change > 0L) {
                Core.get(LogicalSide.SERVER).getPerkRegistry().executePerk(EventType.SKILL_UP, (Player)player, TagBuilder.start().withString("firework_skill", skill).build());
            }
            Networking.sendToClient(new CP_UpdateExperience(skill, this.xp.get(playerID).get(skill), 0L), player);
        }
    }

    public PmmoSavedData() {
    }

    public PmmoSavedData(CompoundTag nbt, HolderLookup.Provider provider) {
        this.xp = new HashMap<UUID, Map<String, Experience>>(XP_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getCompound(XP_KEY)).result().orElse(new HashMap()));
        this.scheduledXP = new HashMap<UUID, Map<String, Experience>>(XP_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getCompound(SCHEDULED_KEY)).result().orElse(new HashMap()));
    }

    public static SavedData.Factory<PmmoSavedData> dataFactory() {
        return new SavedData.Factory(PmmoSavedData::new, PmmoSavedData::new, null);
    }

    @NotNull
    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        Map<UUID, Map> cleanXP = this.xp.entrySet().stream().filter(entry -> !((Map)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        nbt.put(XP_KEY, (Tag)XP_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, cleanXP).result().orElse(new CompoundTag()));
        nbt.put(SCHEDULED_KEY, (Tag)XP_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.scheduledXP).result().orElse(new CompoundTag()));
        return nbt;
    }

    @Override
    public IDataStorage get() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return (IDataStorage)ServerLifecycleHooks.getCurrentServer().overworld().getDataStorage().computeIfAbsent(PmmoSavedData.dataFactory(), NAME);
        }
        return new PmmoSavedData();
    }

    public void awardScheduledXP(UUID playerID) {
        HashMap queue = new HashMap(this.scheduledXP.getOrDefault(playerID, new HashMap()));
        this.scheduledXP.remove(playerID);
        for (Map.Entry scheduledValue : queue.entrySet()) {
            this.addXp(playerID, (String)scheduledValue.getKey(), ((Experience)scheduledValue.getValue()).getXp());
            this.addLevel((String)scheduledValue.getKey(), playerID, ((Experience)scheduledValue.getValue()).getLevel().getLevel());
        }
    }
}

