/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.setup;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import harmonised.pmmo.commands.CmdPmmoRoot;
import harmonised.pmmo.compat.curios.CuriosCompat;
import harmonised.pmmo.compat.ftb_quests.FTBQHandler;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.readers.CoreLoader;
import harmonised.pmmo.config.readers.ExecutableListener;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.perks.PerkRegistration;
import harmonised.pmmo.features.loot_modifiers.SkillUpTrigger;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.setup.datagen.BlockTagProvider;
import harmonised.pmmo.setup.datagen.DamageTagProvider;
import harmonised.pmmo.setup.datagen.EntityTagProvider;
import harmonised.pmmo.setup.datagen.ItemTagProvider;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.setup.datagen.defaultpack.DefaultBiomeConfigProvider;
import harmonised.pmmo.setup.datagen.defaultpack.DefaultBlockConfigProvider;
import harmonised.pmmo.setup.datagen.defaultpack.DefaultDimConfigProvider;
import harmonised.pmmo.setup.datagen.defaultpack.DefaultEntityConfigProvider;
import harmonised.pmmo.setup.datagen.defaultpack.DefaultGLMProvider;
import harmonised.pmmo.setup.datagen.defaultpack.DefaultItemConfigProvider;
import harmonised.pmmo.setup.datagen.easypack.EasyBlockConfigProvider;
import harmonised.pmmo.setup.datagen.easypack.EasyConfigProvider;
import harmonised.pmmo.setup.datagen.easypack.EasyGLMProvider;
import harmonised.pmmo.setup.datagen.easypack.EasyItemConfigProvider;
import harmonised.pmmo.setup.datagen.hardcorepack.HardcoreGLMProvider;
import harmonised.pmmo.util.MsLoggy;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="pmmo", bus=EventBusSubscriber.Bus.GAME)
public class CommonSetup {
    public static final DeferredRegister<CriterionTrigger<?>> TRIGGERS = DeferredRegister.create((Registry)BuiltInRegistries.TRIGGER_TYPES, (String)"pmmo");
    private static final Supplier<SkillUpTrigger> SKILL_UP_TRIGGER = TRIGGERS.register("skill_up", SkillUpTrigger::new);
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"pmmo");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> BREWED = DATA_COMPONENTS.register("brewed", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"pmmo");
    public static final DeferredHolder<Attribute, Attribute> VEIN_CAPACITY = ATTRIBUTES.register("vein_capacity", () -> new RangedAttribute(LangProvider.VEIN_CAP_DESC.key(), 0.0, 0.0, 2.147483647E9).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> VEIN_RECHARGE = ATTRIBUTES.register("vein_charge_rate", () -> new RangedAttribute(LangProvider.VEIN_RATE_DESC.key(), 0.0, 0.0, Double.MAX_VALUE).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> VEIN_AMOUNT = ATTRIBUTES.register("vein_amount", () -> new RangedAttribute(LangProvider.VEIN_AMOUNT.key(), 0.0, 0.0, Double.MAX_VALUE).setSyncable(true));

    public static void init(FMLCommonSetupEvent event) {
        PerkRegistration.init();
        CuriosCompat.hasCurio = ModList.get().isLoaded("curios");
        if (ModList.get().isLoaded("ftbquests")) {
            FTBQHandler.init();
        }
    }

    public static void addAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, VEIN_AMOUNT);
        event.add(EntityType.PLAYER, VEIN_CAPACITY);
        event.add(EntityType.PLAYER, VEIN_RECHARGE);
    }

    @SubscribeEvent
    public static void onServerStartup(ServerStartingEvent event) {
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.LOADING, "Loading PMMO Saved Data", new Object[0]);
        Core.get(LogicalSide.SERVER).getData();
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.LOADING, "PMMO Server loading process complete", new Object[0]);
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        CmdPmmoRoot.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().RELOADER = new ExecutableListener(event.getRegistryAccess(), CoreLoader.RELOADER_FUNCTION);
        event.addListener((PreparableReloadListener)Core.get((LogicalSide)LogicalSide.SERVER).getLoader().RELOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ITEM_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BLOCK_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ENTITY_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BIOME_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().DIMENSION_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().PLAYER_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ENCHANTMENT_LOADER);
        event.addListener(Core.get((LogicalSide)LogicalSide.SERVER).getLoader().EFFECT_LOADER);
        event.addListener((PreparableReloadListener)Config.CONFIG);
        Networking.registerDataSyncPackets();
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture reg = event.getLookupProvider();
        if (event.includeClient()) {
            for (LangProvider.Locale locale : LangProvider.Locale.values()) {
                generator.addProvider(true, (DataProvider)new LangProvider(generator.getPackOutput(), locale.str));
            }
        }
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new EasyGLMProvider(generator.getPackOutput(), reg));
            generator.addProvider(true, (DataProvider)new EasyItemConfigProvider(generator.getPackOutput()));
            generator.addProvider(true, (DataProvider)new EasyBlockConfigProvider(generator.getPackOutput()));
            generator.addProvider(true, (DataProvider)new EasyConfigProvider(generator.getPackOutput()));
            generator.addProvider(true, (DataProvider)new DefaultGLMProvider(generator.getPackOutput(), reg));
            generator.addProvider(true, (DataProvider)new DefaultItemConfigProvider(generator.getPackOutput()));
            generator.addProvider(true, (DataProvider)new DefaultBlockConfigProvider(generator.getPackOutput()));
            generator.addProvider(true, (DataProvider)new DefaultDimConfigProvider(generator.getPackOutput()));
            generator.addProvider(true, (DataProvider)new DefaultBiomeConfigProvider(generator.getPackOutput()));
            generator.addProvider(true, (DataProvider)new DefaultEntityConfigProvider(generator.getPackOutput()));
            generator.addProvider(true, (DataProvider)new HardcoreGLMProvider(generator.getPackOutput(), reg));
            BlockTagProvider blockProvider = new BlockTagProvider(generator.getPackOutput(), reg, event.getExistingFileHelper());
            generator.addProvider(true, (DataProvider)blockProvider);
            generator.addProvider(true, (DataProvider)new EntityTagProvider(generator.getPackOutput(), reg, event.getExistingFileHelper()));
            generator.addProvider(true, (DataProvider)new ItemTagProvider(generator.getPackOutput(), reg, blockProvider.contentsGetter(), event.getExistingFileHelper()));
            generator.addProvider(true, (DataProvider)new DamageTagProvider(generator.getPackOutput(), reg, event.getExistingFileHelper()));
        }
    }
}

