/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.RegistryUtil;
import java.util.function.BiPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PredicateRegistry {
    private final LinkedListMultimap<String, BiPredicate<Player, ItemStack>> reqPredicates = LinkedListMultimap.create();
    private final LinkedListMultimap<String, BiPredicate<Player, BlockEntity>> reqBreakPredicates = LinkedListMultimap.create();
    private final LinkedListMultimap<String, BiPredicate<Player, Entity>> reqEntityPredicates = LinkedListMultimap.create();

    public void registerPredicate(ResourceLocation res, ReqType reqType, BiPredicate<Player, ItemStack> pred) {
        Preconditions.checkNotNull(pred);
        String condition = reqType.toString() + ";" + res.toString();
        this.reqPredicates.get((Object)condition).add(pred);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Predicate Registered: " + condition, new Object[0]);
    }

    public void registerBreakPredicate(ResourceLocation res, ReqType reqType, BiPredicate<Player, BlockEntity> pred) {
        Preconditions.checkNotNull(pred);
        String condition = reqType.toString() + ";" + res.toString();
        this.reqBreakPredicates.get((Object)condition).add(pred);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Predicate Registered: " + condition, new Object[0]);
    }

    public void registerEntityPredicate(ResourceLocation res, ReqType type, BiPredicate<Player, Entity> pred) {
        Preconditions.checkNotNull(pred);
        String condition = type.toString() + ";" + res.toString();
        this.reqEntityPredicates.get((Object)condition).add(pred);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Entity Predicate Regsitered: " + condition, new Object[0]);
    }

    public boolean predicateExists(ResourceLocation res, ReqType type) {
        String key = type.toString() + ";" + res.toString();
        return this.reqPredicates.containsKey((Object)key) || this.reqBreakPredicates.containsKey((Object)key) || this.reqEntityPredicates.containsKey((Object)key);
    }

    public boolean checkPredicateReq(Player player, ItemStack stack, ReqType jType) {
        if (!this.predicateExists(RegistryUtil.getId(player.level().registryAccess(), stack), jType)) {
            return false;
        }
        for (BiPredicate pred : this.reqPredicates.get((Object)(jType.toString() + ";" + RegistryUtil.getId(player.level().registryAccess(), stack).toString()))) {
            if (pred.test(player, stack)) continue;
            return false;
        }
        return true;
    }

    public boolean checkPredicateReq(Player player, BlockEntity tile, ReqType jType) {
        ResourceLocation res = RegistryUtil.getId(tile.getBlockState());
        if (!this.predicateExists(res, jType)) {
            return false;
        }
        for (BiPredicate pred : this.reqBreakPredicates.get((Object)(jType.toString() + ";" + res.toString()))) {
            if (pred.test(player, tile)) continue;
            return false;
        }
        return true;
    }

    public boolean checkPredicateReq(Player player, Entity entity, ReqType type) {
        ResourceLocation res = RegistryUtil.getId(entity);
        if (!this.predicateExists(res, type)) {
            return false;
        }
        for (BiPredicate pred : this.reqEntityPredicates.get((Object)(type.toString() + ";" + res.toString()))) {
            if (pred.test(player, entity)) continue;
            return false;
        }
        return true;
    }
}

