/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.registry;

import com.google.common.base.Preconditions;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class LevelRegistry {
    private final List<BiFunction<String, Long, Long>> providers = new ArrayList<BiFunction<String, Long, Long>>();

    public void registerLevelProvider(BiFunction<String, Long, Long> provider) {
        Preconditions.checkNotNull(provider);
        this.providers.add(provider);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Level Provider Registered", new Object[0]);
    }

    public long process(String skill, long nativeLevel) {
        long outLevel = nativeLevel;
        for (BiFunction<String, Long, Long> provider : this.providers) {
            outLevel = provider.apply(skill, outLevel);
        }
        return outLevel;
    }
}

