/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network.serverpackets;

import harmonised.pmmo.features.loot_modifiers.RareDropModifier;
import harmonised.pmmo.features.loot_modifiers.TreasureLootModifier;
import harmonised.pmmo.mixin.NeoEventHandlerMixin;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_GLMRareSync;
import harmonised.pmmo.network.clientpackets.CP_GLMTreasureSync;
import harmonised.pmmo.util.Reference;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SP_GLMRequest() implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, SP_GLMRequest> STREAM_CODEC = StreamCodec.unit((Object)new SP_GLMRequest());
    public static final CustomPacketPayload.Type<SP_GLMRequest> TYPE = new CustomPacketPayload.Type(Reference.rl("sp_glm_request"));

    public CustomPacketPayload.Type<SP_GLMRequest> type() {
        return TYPE;
    }

    public static void handle(SP_GLMRequest packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            for (IGlobalLootModifier modifier : NeoEventHandlerMixin.getINSTANCE().getAllLootMods()) {
                if (modifier instanceof RareDropModifier) {
                    RareDropModifier rareMod = (RareDropModifier)modifier;
                    Networking.sendToClient(new CP_GLMRareSync(rareMod), (ServerPlayer)ctx.player());
                    continue;
                }
                if (!(modifier instanceof TreasureLootModifier)) continue;
                TreasureLootModifier treasureMod = (TreasureLootModifier)modifier;
                Networking.sendToClient(new CP_GLMTreasureSync(treasureMod), (ServerPlayer)ctx.player());
            }
        });
    }
}

