/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.network.clientpackets.CP_ClearData;
import harmonised.pmmo.network.clientpackets.CP_GLMRareSync;
import harmonised.pmmo.network.clientpackets.CP_GLMTreasureSync;
import harmonised.pmmo.network.clientpackets.CP_ResetXP;
import harmonised.pmmo.network.clientpackets.CP_SetOtherExperience;
import harmonised.pmmo.network.clientpackets.CP_SyncConfig;
import harmonised.pmmo.network.clientpackets.CP_SyncData;
import harmonised.pmmo.network.clientpackets.CP_SyncData_ClearXp;
import harmonised.pmmo.network.clientpackets.CP_UpdateExperience;
import harmonised.pmmo.network.serverpackets.SP_GLMRequest;
import harmonised.pmmo.network.serverpackets.SP_OtherExpRequest;
import harmonised.pmmo.network.serverpackets.SP_SetVeinLimit;
import harmonised.pmmo.network.serverpackets.SP_SetVeinShape;
import harmonised.pmmo.network.serverpackets.SP_ToggleBreakSpeed;
import harmonised.pmmo.network.serverpackets.SP_UpdateVeinTarget;
import harmonised.pmmo.util.MsLoggy;
import java.util.Map;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class Networking {
    @SubscribeEvent
    public static void registerMessages(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("pmmo");
        registrar.playToClient(CP_UpdateExperience.TYPE, CP_UpdateExperience.CODEC, CP_UpdateExperience::handle).playToClient(CP_SyncData.TYPE, CP_SyncData.STREAM_CODEC, CP_SyncData::handle).playToClient(CP_SyncData_ClearXp.TYPE, CP_SyncData_ClearXp.CODEC, CP_SyncData_ClearXp::handle).playToClient(CP_ClearData.TYPE, StreamCodec.unit((Object)new CP_ClearData()), CP_ClearData::handle).playToClient(CP_SetOtherExperience.TYPE, CP_SetOtherExperience.STREAM_CODEC, CP_SetOtherExperience::handle).playToClient(CP_ResetXP.TYPE, StreamCodec.unit((Object)new CP_ResetXP()), CP_ResetXP::handle).playToClient(CP_SyncConfig.TYPE, CP_SyncConfig.STREAM_CODEC, CP_SyncConfig::handle).playToClient(CP_GLMRareSync.TYPE, CP_GLMRareSync.STREAM_CODEC, CP_GLMRareSync::handle).playToClient(CP_GLMTreasureSync.TYPE, CP_GLMTreasureSync.STREAM_COODEC, CP_GLMTreasureSync::handle).playToServer(SP_GLMRequest.TYPE, SP_GLMRequest.STREAM_CODEC, SP_GLMRequest::handle).playToServer(SP_UpdateVeinTarget.TYPE, SP_UpdateVeinTarget.STREAM_CODEC, SP_UpdateVeinTarget::handle).playToServer(SP_OtherExpRequest.TYPE, SP_OtherExpRequest.STREAM_CODEC, SP_OtherExpRequest::handle).playToServer(SP_SetVeinLimit.TYPE, SP_SetVeinLimit.STREAM_CODEC, SP_SetVeinLimit::handle).playToServer(SP_SetVeinShape.TYPE, SP_SetVeinShape.STREAM_CODEC, SP_SetVeinShape::handle).playToServer(SP_ToggleBreakSpeed.TYPE, SP_ToggleBreakSpeed.STREAM_CODEC, SP_ToggleBreakSpeed::handle);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.NETWORK, "Messages Registered", new Object[0]);
    }

    public static void registerDataSyncPackets() {
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().RELOADER.subscribeAsSyncable(CP_ClearData::new);
        Config.CONFIG.subscribeAsSyncable();
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ITEM_LOADER.subscribeAsSyncable(o -> new CP_SyncData(ObjectType.ITEM, (Map<ResourceLocation, ? extends DataSource<?>>)o));
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BLOCK_LOADER.subscribeAsSyncable(o -> new CP_SyncData(ObjectType.BLOCK, (Map<ResourceLocation, ? extends DataSource<?>>)o));
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ENTITY_LOADER.subscribeAsSyncable(o -> new CP_SyncData(ObjectType.ENTITY, (Map<ResourceLocation, ? extends DataSource<?>>)o));
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().BIOME_LOADER.subscribeAsSyncable(o -> new CP_SyncData(ObjectType.BIOME, (Map<ResourceLocation, ? extends DataSource<?>>)o));
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().DIMENSION_LOADER.subscribeAsSyncable(o -> new CP_SyncData(ObjectType.DIMENSION, (Map<ResourceLocation, ? extends DataSource<?>>)o));
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().ENCHANTMENT_LOADER.subscribeAsSyncable(o -> new CP_SyncData(ObjectType.ENCHANTMENT, (Map<ResourceLocation, ? extends DataSource<?>>)o));
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().EFFECT_LOADER.subscribeAsSyncable(o -> new CP_SyncData(ObjectType.EFFECT, (Map<ResourceLocation, ? extends DataSource<?>>)o));
        Core.get((LogicalSide)LogicalSide.SERVER).getLoader().PLAYER_LOADER.subscribeAsSyncable(o -> new CP_SyncData(ObjectType.PLAYER, (Map<ResourceLocation, ? extends DataSource<?>>)o));
    }

    public static void sendToClient(CustomPacketPayload packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

