/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.veinmining;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VeinShapeData {
    private final Level level;
    private final BlockPos center;
    private int maxBlocks;
    private final Map<BlockPos, Node> map = new HashMap<BlockPos, Node>();
    private final ShapeType mode;
    private final Direction face;

    public VeinShapeData(Level level, BlockPos center, int maxBlocks, ShapeType mode, Direction playerFacing) {
        this.level = level;
        this.center = center;
        this.maxBlocks = maxBlocks;
        this.mode = mode;
        this.face = playerFacing;
        this.map.put(center, new Node(0, false, false));
    }

    public Set<BlockPos> getVein() {
        Block block = this.level.getBlockState(this.center).getBlock();
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                int ring = 0;
                while (this.maxBlocks > 0) {
                    this.addNodesForRing(ring, block);
                    ++ring;
                }
                this.map.remove(this.center);
                yield this.map.keySet();
            }
            case 1 -> {
                BlockState centerState = this.level.getBlockState(this.center);
                BlockPos lastPos = this.center;
                while (this.maxBlocks > 0 && !lastPos.equals((Object)BlockPos.ZERO)) {
                    lastPos = this.stepShape(lastPos, centerState, false);
                }
                this.map.remove(this.center);
                yield this.map.keySet();
            }
            case 2 -> {
                BlockState centerState = this.level.getBlockState(this.center);
                BlockPos lastPos = this.center;
                while (this.maxBlocks > 0 && !lastPos.equals((Object)BlockPos.ZERO)) {
                    lastPos = this.stepShape(lastPos, centerState, true);
                }
                this.map.remove(this.center);
                yield this.map.keySet();
            }
        };
    }

    private void addNodesForRing(int ring, Block block) {
        HashMap<BlockPos, Node> ringMap = new HashMap<BlockPos, Node>();
        this.map.forEach((pos, node) -> {
            if (node.ring() == ring && !node.scanned() && !node.isTerminal()) {
                ringMap.put((BlockPos)pos, (Node)node);
            }
        });
        if (ringMap.isEmpty()) {
            this.maxBlocks = 0;
            return;
        }
        ringMap.forEach((pos, node) -> {
            this.map.put((BlockPos)pos, node.setScanned());
            HashMap<BlockPos, Node> newRingMap = new HashMap<BlockPos, Node>();
            block0: for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (this.maxBlocks <= 0) break block0;
                        BlockPos currentPos = pos.offset(x, y, z);
                        if (this.map.containsKey(currentPos) || !this.level.getBlockState(currentPos).getBlock().equals(block)) continue;
                        newRingMap.put(currentPos, new Node(ring + 1, false, false));
                        --this.maxBlocks;
                    }
                }
            }
            if (newRingMap.isEmpty()) {
                this.map.put((BlockPos)pos, node.setScanned().setTerminal());
            } else {
                this.map.putAll(newRingMap);
            }
        });
    }

    private BlockPos stepShape(BlockPos from, BlockState centerState, boolean isBig) {
        boolean allFalse = true;
        if (this.level.getBlockState(from).getBlock().equals(centerState.getBlock())) {
            this.map.put(from, Node.NONE);
            --this.maxBlocks;
            allFalse = false;
        }
        if (this.maxBlocks > 0 && this.level.getBlockState(from.below()).getBlock().equals(centerState.getBlock())) {
            this.map.put(from.below(), Node.NONE);
            --this.maxBlocks;
            allFalse = false;
        }
        if (isBig) {
            if (this.maxBlocks > 0 && this.level.getBlockState(from.above()).getBlock().equals(centerState.getBlock())) {
                this.map.put(from.above(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.getBlockState(this.getAdjacent(from, true)).getBlock().equals(centerState.getBlock())) {
                this.map.put(this.getAdjacent(from, true), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.getBlockState(this.getAdjacent(from, true).above()).getBlock().equals(centerState.getBlock())) {
                this.map.put(this.getAdjacent(from, true).above(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.getBlockState(this.getAdjacent(from, true).below()).getBlock().equals(centerState.getBlock())) {
                this.map.put(this.getAdjacent(from, true).below(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.getBlockState(this.getAdjacent(from, false)).getBlock().equals(centerState.getBlock())) {
                this.map.put(this.getAdjacent(from, false), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.getBlockState(this.getAdjacent(from, false).above()).getBlock().equals(centerState.getBlock())) {
                this.map.put(this.getAdjacent(from, false).above(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
            if (this.maxBlocks > 0 && this.level.getBlockState(this.getAdjacent(from, false).below()).getBlock().equals(centerState.getBlock())) {
                this.map.put(this.getAdjacent(from, false).below(), Node.NONE);
                --this.maxBlocks;
                allFalse = false;
            }
        }
        if (allFalse) {
            return BlockPos.ZERO;
        }
        return from.relative(this.face);
    }

    private BlockPos getAdjacent(BlockPos pos, boolean left) {
        return switch (this.face) {
            case Direction.NORTH -> {
                if (left) {
                    yield pos.west();
                }
                yield pos.east();
            }
            case Direction.SOUTH -> {
                if (left) {
                    yield pos.east();
                }
                yield pos.west();
            }
            case Direction.WEST -> {
                if (left) {
                    yield pos.south();
                }
                yield pos.north();
            }
            case Direction.EAST -> {
                if (left) {
                    yield pos.north();
                }
                yield pos.south();
            }
            default -> pos;
        };
    }

    public static enum ShapeType {
        AOE,
        TUNNEL,
        BIG_TUNNEL;

    }

    private record Node(int ring, boolean scanned, boolean isTerminal) {
        public static Node NONE = new Node(0, false, false);

        public Node setScanned() {
            return new Node(this.ring(), true, this.isTerminal());
        }

        public Node setTerminal() {
            return new Node(this.ring(), this.scanned(), true);
        }
    }
}

