/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.penalties;

import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.compat.curios.CuriosCompat;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class EffectManager {
    public static void applyEffects(Core core, Player player) {
        List<MobEffectInstance> effects;
        Holder biome = player.level().getBiome(player.blockPosition());
        ResourceKey dimension = player.level().dimension();
        List<MobEffectInstance> list = effects = core.isActionPermitted(ReqType.TRAVEL, (Holder<Biome>)biome, player) ? CoreUtils.getEffects(core.getLoader().getLoader(ObjectType.BIOME).getData(RegistryUtil.getId(biome)).getPositiveEffect(), false) : CoreUtils.getEffects(core.getLoader().getLoader(ObjectType.BIOME).getData(RegistryUtil.getId(biome)).getNegativeEffect(), true);
        if (core.isActionPermitted(ReqType.TRAVEL, (ResourceKey<Level>)dimension, player)) {
            effects.addAll(CoreUtils.getEffects(core.getLoader().getLoader(ObjectType.DIMENSION).getData(dimension.location()).getPositiveEffect(), false));
        }
        for (MobEffectInstance mei : effects) {
            if (player.hasEffect(mei.getEffect()) && player.getEffect(mei.getEffect()).getDuration() >= 10) continue;
            player.addEffect(mei);
        }
        Inventory inv = player.getInventory();
        List<ItemStack> items = List.of(inv.getItem(36), inv.getItem(37), inv.getItem(38), inv.getItem(39), player.getMainHandItem(), player.getOffhandItem());
        if (CuriosCompat.hasCurio) {
            items = new ArrayList<ItemStack>(items);
            items.addAll(CuriosCompat.getItems(player));
        }
        for (ItemStack stack : items) {
            if (stack.isEmpty() || core.isActionPermitted(ReqType.WEAR, stack, player)) continue;
            for (MobEffectInstance mei : CoreUtils.getEffects(core.getLoader().getLoader(ObjectType.ITEM).getData(RegistryUtil.getId(player.level().registryAccess(), stack)).getNegativeEffect(), true)) {
                if (player.hasEffect(mei.getEffect()) && player.getEffect(mei.getEffect()).getDuration() >= 10) continue;
                player.addEffect(mei);
            }
        }
    }
}

