/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.TagUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class RareDropModifier
extends LootModifier {
    public static final MapCodec<RareDropModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> RareDropModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(tlm -> tlm.drop), (App)Codec.INT.fieldOf("count").forGetter(tlm -> tlm.drop.getCount()), (App)Codec.DOUBLE.fieldOf("chance").forGetter(tlm -> tlm.chance), (App)Codec.BOOL.optionalFieldOf("per_level").forGetter(tlm -> Optional.of(tlm.perLevel)), (App)Codec.STRING.optionalFieldOf("skill").forGetter(tlm -> Optional.of(tlm.skill)))).apply((Applicative)instance, RareDropModifier::new));
    public ItemStack drop;
    public double chance;
    public boolean perLevel;
    public String skill;

    public RareDropModifier(LootItemCondition[] conditionsIn, ItemStack lootItem, int count, double chance) {
        this(conditionsIn, lootItem, count, chance, Optional.of(false), Optional.empty());
    }

    public RareDropModifier(LootItemCondition[] conditionsIn, ItemStack lootItem, int count, double chance, Optional<Boolean> perLevel, Optional<String> skill) {
        super(conditionsIn);
        this.chance = chance;
        this.drop = lootItem;
        this.drop.setCount(count);
        this.perLevel = perLevel.orElse(false);
        this.skill = skill.orElse("");
    }

    public LootItemCondition[] getConditions() {
        return this.conditions;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        double rand;
        Object object;
        if (!Config.server().general().treasureEnabled()) {
            return generatedLoot;
        }
        if (this.perLevel && (object = context.getParam(LootContextParams.THIS_ENTITY)) instanceof Player) {
            Player player = (Player)object;
            this.chance *= (double)Core.get(player.level()).getData().getLevel(this.skill, player.getUUID());
        }
        if ((rand = MsLoggy.DEBUG.logAndReturn(context.getRandom().nextDouble(), MsLoggy.LOG_CODE.FEATURE, "Rand: {} as test for " + String.valueOf(TagUtils.stackTag(this.drop, (Level)context.getLevel())), new Object[0]).doubleValue()) <= this.chance) {
            generatedLoot.add((Object)this.drop.copy());
        }
        return generatedLoot;
    }
}

