/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.living.LivingEvent;

public class JumpHandler {
    public static void handle(LivingEvent.LivingJumpEvent event) {
        boolean serverSide;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        EventType type = EventType.JUMP;
        if (player.isSprinting()) {
            type = EventType.SPRINT_JUMP;
        } else if (player.isCrouching()) {
            type = EventType.CROUCH_JUMP;
        }
        Core core = Core.get(player.level());
        CompoundTag eventHookOutput = new CompoundTag();
        boolean bl = serverSide = !player.level().isClientSide;
        if (serverSide) {
            eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(type, (Event)event, new CompoundTag());
        }
        CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(type, player, eventHookOutput));
        if (serverSide) {
            double jumpXpBase = perkOutput.contains("jump_boost_output") ? Math.max(0.4, perkOutput.getDouble("jump_boost_output")) : player.getDeltaMovement().y;
            HashMap<String, Long> xpAward = new HashMap<String, Long>();
            Map<String, Double> ratios = Config.server().xpGains().playerXp(type);
            ratios.keySet().forEach(skill -> {
                Double xpValue = ratios.getOrDefault(skill, 2.5) * jumpXpBase * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
                xpAward.put((String)skill, xpValue.longValue());
            });
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
            core.awardXP(partyMembersInRange, xpAward);
        }
    }
}

