/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;

public class FishHandler {
    public static void handle(ItemFishedEvent event) {
        Player player = event.getEntity();
        Core core = Core.get(player.level());
        if (!core.isActionPermitted(ReqType.TOOL, player.getMainHandItem(), player)) {
            event.setCanceled(true);
            Messenger.sendDenialMsg(ReqType.TOOL, player, player.getMainHandItem().getDisplayName());
            return;
        }
        boolean serverSide = !player.level().isClientSide;
        CompoundTag eventHookOutput = new CompoundTag();
        if (serverSide && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.FISH, (Event)event, new CompoundTag())).getBoolean("is_cancelled")) {
            event.setCanceled(true);
            return;
        }
        CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(EventType.FISH, player, eventHookOutput));
        if (serverSide) {
            HashMap<String, Long> xpAward = new HashMap<String, Long>();
            for (ItemStack stack : event.getDrops()) {
                core.getExperienceAwards(EventType.FISH, stack, event.getEntity(), perkOutput).forEach((skill, value) -> xpAward.merge((String)skill, (Long)value, Long::sum));
            }
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
            core.awardXP(partyMembersInRange, xpAward);
        }
    }
}

