/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class DamageDealtHandler {
    public static void handle(EntityInvulnerabilityCheckEvent event) {
        if (event.getSource().getEntity() == null) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof LivingEntity) {
                CompoundTag eventHookOutput;
                LivingEntity target = (LivingEntity)entity;
                if (target.equals((Object)player)) {
                    return;
                }
                Core core = Core.get(player.level());
                MsLoggy.INFO.log(MsLoggy.LOG_CODE.EVENT, "Attack Type: " + EventType.DEAL_DAMAGE.name() + " | TargetType: " + target.getType().toString(), new Object[0]);
                if (!core.isActionPermitted(ReqType.WEAPON, player.getMainHandItem(), player)) {
                    event.setInvulnerable(true);
                    Messenger.sendDenialMsg(ReqType.WEAPON, player, player.getMainHandItem().getDisplayName());
                    return;
                }
                if (!core.isActionPermitted(ReqType.KILL, (Entity)target, player)) {
                    event.setInvulnerable(true);
                    Messenger.sendDenialMsg(ReqType.KILL, player, target.getDisplayName());
                    return;
                }
                if (!player.level().isClientSide && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.DEAL_DAMAGE, (Event)event, new CompoundTag())).getBoolean("is_cancelled")) {
                    event.setInvulnerable(true);
                }
            }
        }
    }

    public static void handle(LivingDamageEvent.Pre event) {
        DamageContainer container = event.getContainer();
        DamageSource source = container.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LivingEntity target = event.getEntity();
            if (target.equals((Object)player)) {
                return;
            }
            Core core = Core.get(player.level());
            String damageType = RegistryUtil.getId(player.level().registryAccess(), Registries.DAMAGE_TYPE, source.type()).toString();
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Source Type: " + damageType + " | Source Raw: " + source.getMsgId(), new Object[0]);
            CompoundTag dataIn = TagBuilder.start().withFloat("damageIn", container.getNewDamage()).withFloat("damage", container.getNewDamage()).withString("damage_type", damageType).build();
            CompoundTag perkOutput = core.getPerkRegistry().executePerk(EventType.DEAL_DAMAGE, player, dataIn);
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Pre-Perk Damage:" + container.getNewDamage(), new Object[0]);
            if (perkOutput.contains("damage")) {
                float damageOut = perkOutput.getFloat("damage");
                MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Damage Modified from %s to %s".formatted(Float.valueOf(container.getNewDamage()), Float.valueOf(damageOut)), new Object[0]);
                event.getContainer().setNewDamage(damageOut);
            }
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Attack Type: " + damageType + " | Damage Out: " + container.getNewDamage(), new Object[0]);
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                perkOutput.putString("damage_type", damageType);
                Map<String, Long> xpAward = DamageDealtHandler.getExperienceAwards(core, target, container.getNewDamage(), source, (Player)splayer, perkOutput);
                List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange(splayer);
                core.awardXP(partyMembersInRange, xpAward);
            }
        }
    }

    private static Map<String, Long> getExperienceAwards(Core core, LivingEntity target, float damage, DamageSource source, Player player, CompoundTag dataIn) {
        HashMap<String, Long> mapOut = new HashMap<String, Long>();
        if (target.getType().is(Reference.NO_XP_DAMAGE_DEALT)) {
            return mapOut;
        }
        float ultimateDamage = Math.min(damage, target.getHealth());
        ItemStack weapon = player.getMainHandItem();
        Player srcEntity = source.getDirectEntity() != null ? source.getDirectEntity() : player;
        Functions.mergeMaps(core.getExperienceAwards(EventType.DEAL_DAMAGE, weapon, player, dataIn), core.getExperienceAwards(EventType.DEAL_DAMAGE, (Entity)srcEntity, player, dataIn), core.getExperienceAwards(EventType.DEAL_DAMAGE, (Entity)target, player, dataIn)).forEach((skill, xp) -> mapOut.put((String)skill, (long)(xp.floatValue() * ultimateDamage)));
        Map<String, Map<String, Long>> config = Config.server().xpGains().dealtDamage();
        List<String> tags = config.keySet().stream().filter(str -> {
            if (!str.contains("#")) {
                return false;
            }
            Registry registry = player.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
            Optional tag = registry.getTag(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Reference.of(str.substring(1))));
            return tag.map(type -> type.contains(source.typeHolder())).orElse(false);
        }).toList();
        Map tagXp = tags.stream().map(str -> (Map)config.get(str)).reduce((mapA, mapB) -> Functions.mergeMaps(mapA, mapB)).orElse(new HashMap());
        Functions.mergeMaps((Map)config.getOrDefault(RegistryUtil.getId(player.level().registryAccess(), Registries.DAMAGE_TYPE, source.type()).toString(), new HashMap()), tagXp).forEach((skill, xp) -> mapOut.putIfAbsent((String)skill, (long)(xp.floatValue() * ultimateDamage)));
        CoreUtils.applyXpModifiers(mapOut, core.getConsolidatedModifierMap(player));
        return mapOut;
    }
}

