/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.scripting.Functions;
import harmonised.pmmo.util.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public record SkillData(Optional<Integer> color, Optional<Boolean> afkExempt, Optional<Boolean> displayGroupName, Optional<Boolean> showInList, Optional<Boolean> useTotalLevels, Optional<Map<String, Double>> groupedSkills, Optional<Long> maxLevel, Optional<ResourceLocation> icon, Optional<Integer> iconSize) {
    private static final String COLOR = "color";
    private static final String ICON_SIZE = "iconSize";
    private static final String ICON = "icon";
    private static final String MAX_LEVEL = "maxLevel";
    private static final String AFK_EXEMPT = "noAfkPenalty";
    private static final String DISPLAY = "displayGroupName";
    private static final String SHOW_LIST = "showInList";
    private static final String USE_TOTAL_LVL = "useTotalLevels";
    private static final String GROUP_FOR = "groupFor";
    public static Codec<SkillData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf(COLOR).forGetter(SkillData::color), (App)Codec.BOOL.optionalFieldOf(AFK_EXEMPT).forGetter(SkillData::afkExempt), (App)Codec.BOOL.optionalFieldOf(DISPLAY).forGetter(SkillData::displayGroupName), (App)Codec.BOOL.optionalFieldOf(SHOW_LIST).forGetter(SkillData::showInList), (App)Codec.BOOL.optionalFieldOf(USE_TOTAL_LVL).forGetter(SkillData::useTotalLevels), (App)CodecTypes.DOUBLE_CODEC.optionalFieldOf(GROUP_FOR).forGetter(SkillData::groupedSkills), (App)Codec.LONG.optionalFieldOf(MAX_LEVEL).forGetter(SkillData::maxLevel), (App)ResourceLocation.CODEC.optionalFieldOf(ICON).forGetter(SkillData::icon), (App)Codec.INT.optionalFieldOf(ICON_SIZE).forGetter(SkillData::iconSize)).apply((Applicative)instance, SkillData::new));

    public int getColor() {
        return this.color.orElse(0xFFFFFF);
    }

    public boolean getAfkExempt() {
        return this.afkExempt.orElse(false);
    }

    public boolean getDisplayGroupName() {
        return this.displayGroupName.orElse(false);
    }

    public boolean getShowInList() {
        return this.showInList.orElse(true);
    }

    public boolean getUseTotalLevels() {
        return this.useTotalLevels.orElse(false);
    }

    public long getMaxLevel() {
        return this.maxLevel.orElse(Config.server().levels().maxLevel());
    }

    public ResourceLocation getIcon() {
        return this.icon.orElse(Reference.rl("textures/skills/missing_icon.png"));
    }

    public int getIconSize() {
        return this.iconSize.orElse(18);
    }

    public boolean isSkillGroup() {
        return !this.getGroup().isEmpty();
    }

    public Map<String, Double> getGroup() {
        return this.groupedSkills.orElse(new HashMap());
    }

    public Map<String, Long> getGroupXP(long xp) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double denominator = this.getGroup().values().stream().mapToDouble(value -> value).sum();
        this.getGroup().forEach((skill, ratio) -> outMap.put((String)skill, Double.valueOf(ratio / denominator * (double)xp).longValue()));
        new HashMap<String, Long>(outMap).forEach((skill, value) -> {
            SkillData skillCheck = Config.skills().get((String)skill);
            if (skillCheck.isSkillGroup()) {
                outMap.remove(skill);
                skillCheck.getGroupXP((long)value).forEach((s, x) -> outMap.merge((String)s, (Long)x, Long::sum));
            }
        });
        return outMap;
    }

    public Map<String, Long> getGroupReq(long level) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double denominator = this.getGroup().values().stream().mapToDouble(value -> value).sum();
        this.getGroup().forEach((skill, ratio) -> outMap.put((String)skill, (long)(ratio / denominator * (double)level)));
        new HashMap<String, Long>(outMap).forEach((skill, value) -> {
            SkillData skillCheck = Config.skills().get((String)skill);
            if (skillCheck.isSkillGroup()) {
                outMap.remove(skill);
                skillCheck.getGroupReq((long)value).forEach((s, x) -> outMap.merge((String)s, (Long)x, Long::sum));
            }
        });
        return outMap;
    }

    public Map<String, Double> getGroupBonus(double bonus) {
        HashMap<String, Double> outMap = new HashMap<String, Double>();
        double denominator = this.getGroup().values().stream().mapToDouble(value -> value).sum();
        double gainLossModifier = bonus >= 1.0 ? 1.0 : 0.0;
        this.getGroup().forEach((skill, ratio) -> outMap.put((String)skill, gainLossModifier + ratio / denominator * bonus));
        new HashMap<String, Double>(outMap).forEach((skill, value) -> {
            SkillData skillCheck = Config.skills().get((String)skill);
            if (skillCheck.isSkillGroup()) {
                outMap.remove(skill);
                skillCheck.getGroupBonus((double)value).forEach((s, x) -> outMap.merge((String)s, (Double)x, Double::sum));
            }
        });
        return outMap;
    }

    public static class Builder {
        int color = 0xFFFFFF;
        int iconSize = 18;
        long maxLevel = Integer.MAX_VALUE;
        boolean afkExempt = false;
        boolean displayName = false;
        boolean useTotal = false;
        boolean showInList = true;
        ResourceLocation icon = Reference.rl("textures/skills/missing_icon.png");
        Map<String, Double> groupOf = new HashMap<String, Double>();

        private Builder() {
        }

        public static SkillData getDefault() {
            return new SkillData(Optional.of(0xFFFFFF), Optional.of(false), Optional.of(false), Optional.of(true), Optional.of(false), Optional.empty(), Optional.of(Config.server().levels().maxLevel()), Optional.of(Reference.rl("textures/skills/missing_icon.png")), Optional.of(18));
        }

        public static Builder start() {
            return new Builder();
        }

        public Builder withColor(int color) {
            this.color = color;
            return this;
        }

        public Builder withIcon(ResourceLocation icon) {
            this.icon = icon;
            return this;
        }

        public Builder withIconSize(int size) {
            this.iconSize = size;
            return this;
        }

        public Builder withMaxLevel(long maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public Builder withAfkExempt(boolean afkExempt) {
            this.afkExempt = afkExempt;
            return this;
        }

        public Builder withDisplayName(boolean displayGroupName) {
            this.displayName = displayGroupName;
            return this;
        }

        public Builder withUseTotal(boolean useTotalLevels) {
            this.useTotal = useTotalLevels;
            return this;
        }

        public Builder withShowInList(boolean show) {
            this.showInList = show;
            return this;
        }

        public Builder setGroupOf(Map<String, Double> group) {
            this.groupOf = group;
            return this;
        }

        public SkillData build() {
            return new SkillData(Optional.of(this.color), Optional.of(this.afkExempt), Optional.of(this.displayName), Optional.of(this.showInList), Optional.of(this.useTotal), this.groupOf.isEmpty() ? Optional.empty() : Optional.of(this.groupOf), Optional.of(this.maxLevel), Optional.of(this.icon), Optional.of(this.iconSize));
        }

        public SkillData fromScripting(Map<String, String> values) {
            if (values.containsKey(SkillData.COLOR)) {
                this.withColor(Integer.parseInt(values.get(SkillData.COLOR)));
            }
            if (values.containsKey(SkillData.ICON_SIZE)) {
                this.withIconSize(Integer.parseInt(values.get(SkillData.ICON_SIZE)));
            }
            if (values.containsKey(SkillData.MAX_LEVEL)) {
                this.withMaxLevel(Long.parseLong(values.get(SkillData.MAX_LEVEL)));
            }
            if (values.containsKey(SkillData.AFK_EXEMPT)) {
                this.withAfkExempt(Boolean.parseBoolean(values.get(SkillData.AFK_EXEMPT)));
            }
            if (values.containsKey(SkillData.DISPLAY)) {
                this.withDisplayName(Boolean.parseBoolean(values.get(SkillData.DISPLAY)));
            }
            if (values.containsKey(SkillData.USE_TOTAL_LVL)) {
                this.withUseTotal(Boolean.parseBoolean(values.get(SkillData.USE_TOTAL_LVL)));
            }
            if (values.containsKey(SkillData.SHOW_LIST)) {
                this.withShowInList(Boolean.parseBoolean(values.get(SkillData.SHOW_LIST)));
            }
            if (values.containsKey(SkillData.ICON)) {
                this.withIcon(Reference.of(values.get(SkillData.ICON)));
            }
            if (values.containsKey(SkillData.GROUP_FOR)) {
                this.setGroupOf(Functions.doubleMap(values.get(SkillData.GROUP_FOR)));
            }
            return this.build();
        }
    }
}

