/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.codecs.ConfigData;
import harmonised.pmmo.config.readers.ConfigListener;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;

public record PerksConfig(Map<EventType, List<CompoundTag>> perks) implements ConfigData<PerksConfig>
{
    public static final MapCodec<PerksConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap(EventType.CODEC, (Codec)CompoundTag.CODEC.listOf()).fieldOf("perks").forGetter(PerksConfig::perks)).apply((Applicative)instance, PerksConfig::new));
    private static final String EVENT = "event";
    private static final String CLEAR = "clear_all";

    public PerksConfig() {
        this(PerksConfig.generateDefaults());
    }

    private static Map<EventType, List<CompoundTag>> generateDefaults() {
        HashMap<EventType, List<CompoundTag>> defaultSettings = new HashMap<EventType, List<CompoundTag>>();
        ArrayList<CompoundTag> bodyList = new ArrayList<CompoundTag>();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:break_speed").withString("skill", "mining").withDouble("pickaxe_dig", 0.005).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:break_speed").withString("skill", "excavation").withDouble("shovel_dig", 0.005).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:break_speed").withString("skill", "woodcutting").withDouble("axe_dig", 0.005).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:break_speed").withString("skill", "farming").withDouble("sword_dig", 0.005).withDouble("hoe_dig", 0.005).withDouble("shears_dig", 0.005).build());
        defaultSettings.put(EventType.BREAK_SPEED, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "mining").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "building").withString("attribute", RegistryUtil.getAttributeId((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE).toString()).withDouble("per_level", 0.05).withDouble("max_boost", 10.0).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "building").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "excavation").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "woodcutting").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "farming").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withInt("per_x_level", 10).withString("skill", "agility").withString("attribute", RegistryUtil.getAttributeId((Holder<Attribute>)Attributes.MOVEMENT_SPEED).toString()).withDouble("per_level", 1.5E-5).withDouble("max_boost", 1.0).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "agility").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "endurance").withString("attribute", RegistryUtil.getAttributeId((Holder<Attribute>)Attributes.MAX_HEALTH).toString()).withDouble("per_level", 0.05).withDouble("max_boost", 10.0).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "endurance").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "combat").withString("attribute", RegistryUtil.getAttributeId((Holder<Attribute>)Attributes.ATTACK_DAMAGE).toString()).withDouble("per_level", 0.005).withDouble("max_boost", 1.0).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "combat").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "gunslinging").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "archery").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "smithing").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "flying").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "swimming").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "sailing").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "fishing").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "crafting").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "magic").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "magic").withDouble("max_boost", 3000.0).withDouble("per_level", 3.0).withString("attribute", "ars_nouveau:ars_nouveau.perk.max_mana").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "magic").withDouble("max_boost", 100.0).withDouble("per_level", 0.06).withString("attribute", "ars_nouveau:ars_nouveau.perk.mana_regen").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "magic").withDouble("max_boost", 0.0).withDouble("per_level", 0.0).withString("attribute", "ars_nouveau:ars_nouveau.perk.spell_damage").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "magic").withDouble("max_boost", 1.0).withDouble("per_level", 0.005).withString("attribute", "irons_spellbooks:cooldown_reduction").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "magic").withDouble("max_boost", 2.0).withDouble("per_level", 0.01).withString("attribute", "irons_spellbooks:spell_power").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "magic").withDouble("max_boost", 300.0).withDouble("per_level", 1.0).withString("attribute", "irons_spellbooks:mana_regen").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "slayer").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "hunter").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "taming").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "cooking").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", "alchemy").build());
        defaultSettings.put(EventType.SKILL_UP, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:jump_boost").withString("skill", "agility").withDouble("per_level", 5.0E-4).build());
        defaultSettings.put(EventType.JUMP, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:jump_boost").withString("skill", "agility").withDouble("per_level", 0.001).build());
        defaultSettings.put(EventType.SPRINT_JUMP, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:jump_boost").withString("skill", "agility").withDouble("per_level", 0.0015).build());
        defaultSettings.put(EventType.CROUCH_JUMP, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:breath").withString("skill", "swimming").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:effect").withString("skill", "swimming").withString("effect", "minecraft:night_vision").withInt("max_boost", 160).withInt("min_level", 25).build());
        defaultSettings.put(EventType.SUBMERGED, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:villager_boost").withString("skill", "charisma").build());
        defaultSettings.put(EventType.ENTITY, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:damage_reduce").withString("skill", "agility").withString("for_damage", "minecraft:fall").withDouble("per_level", 0.025).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:damage_reduce").withString("skill", "endurance").withString("for_damage", "minecraft:mob_attack").withDouble("per_level", 0.025).build());
        defaultSettings.put(EventType.RECEIVE_DAMAGE, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:damage_boost").withString("skill", "archery").withList("applies_to", new Tag[]{StringTag.valueOf((String)"minecraft:bow"), StringTag.valueOf((String)"minecraft:crossbow"), StringTag.valueOf((String)"minecraft:trident")}).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:damage_boost").withString("skill", "magic").withList("applies_to", new Tag[]{StringTag.valueOf((String)"ars_nouveau:spell_bow")}).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:damage_boost").withString("skill", "magic").withList("for_damage", new Tag[]{StringTag.valueOf((String)"#pmmo:magic")}).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:damage_boost").withString("skill", "gunslinging").withList("for_damage", new Tag[]{StringTag.valueOf((String)"#pmmo:gun")}).build());
        defaultSettings.put(EventType.DEAL_DAMAGE, new ArrayList(bodyList));
        return defaultSettings;
    }

    @Override
    public MapCodec<PerksConfig> getCodec() {
        return CODEC;
    }

    @Override
    public ConfigListener.ServerConfigs getType() {
        return ConfigListener.ServerConfigs.PERKS;
    }

    @Override
    public ConfigData<PerksConfig> getFromScripting(String param, Map<String, String> value) {
        if (param.equals(CLEAR)) {
            return new PerksConfig(new HashMap<EventType, List<CompoundTag>>());
        }
        if (value.containsKey(EVENT)) {
            EventType type = EventType.byName(value.get(EVENT));
            if (type == null) {
                MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, "perk script for event {%s} is not valid", value.get(EVENT));
                return this;
            }
            PerksConfig config = new PerksConfig(this.makeMutable(this.perks()));
            config.perks().computeIfAbsent(type, t -> new ArrayList()).add(this.tagFromValueMap(value));
            return config;
        }
        return this;
    }

    private CompoundTag tagFromValueMap(Map<String, String> values) {
        CompoundTag outTag = new CompoundTag();
        values.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(EVENT)).forEach(entry -> {
            try {
                Tag tag = new TagParser(new StringReader((String)entry.getValue())).readValue();
                outTag.put((String)entry.getKey(), tag);
            }
            catch (CommandSyntaxException e) {
                MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, "unable to parse perk value %s", entry.getValue());
            }
        });
        return outTag;
    }

    private Map<EventType, List<CompoundTag>> makeMutable(Map<EventType, List<CompoundTag>> inMap) {
        HashMap<EventType, List<CompoundTag>> outMap = new HashMap<EventType, List<CompoundTag>>();
        inMap.forEach((type, list) -> outMap.put((EventType)type, new ArrayList(list)));
        return outMap;
    }

    @Override
    public PerksConfig combine(PerksConfig two) {
        return two;
    }

    @Override
    public boolean isUnconfigured() {
        return false;
    }
}

