/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.utils;

import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;

public class ClientUtils {
    private static Minecraft mc = Minecraft.getInstance();
    private static Map<String, Map<Long, Map<ReqType, List<Component>>>> cache = new HashMap<String, Map<Long, Map<ReqType, List<Component>>>>();

    public static List<ClientTooltipComponent> ctc(MutableComponent component, int width) {
        return ClientUtils.mc.font.split((FormattedText)component, width).stream().map(fcs -> ClientTooltipComponent.create((FormattedCharSequence)fcs)).toList();
    }

    public static void invalidateUnlocksCache() {
        cache.clear();
    }

    private static void cacheUnlocks() {
        LocalPlayer player = ClientUtils.mc.player;
        Core core = Core.get(LogicalSide.CLIENT);
        Arrays.stream(ReqType.values()).forEach(reqType -> {
            ArrayList objects = new ArrayList();
            if (reqType.itemApplicable) {
                BuiltInRegistries.ITEM.stream().map(ItemStack::new).forEach(stack -> core.getReqMap((ReqType)reqType, (ItemStack)stack, player.level(), false).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(stack.getDisplayName())));
            }
            if (reqType.blockApplicable) {
                BuiltInRegistries.BLOCK.stream().forEach(block -> core.getCommonReqData((Map<String, Long>)new HashMap<String, Long>(), ObjectType.BLOCK, RegistryUtil.getId(block), (ReqType)reqType, new CompoundTag()).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(new ItemStack((ItemLike)block.asItem()).getDisplayName())));
            }
            if (reqType.entityApplicable) {
                BuiltInRegistries.ENTITY_TYPE.stream().map(entity -> entity.create(player.level())).filter(Objects::nonNull).forEach(entity -> core.getReqMap((ReqType)reqType, (Entity)entity).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(entity.getDisplayName())));
            }
            if (reqType == ReqType.TRAVEL) {
                player.level().registryAccess().registryOrThrow(Registries.BIOME).entrySet().stream().map(entry -> ((ResourceKey)entry.getKey()).location()).forEach(biomeID -> core.getCommonReqData((Map<String, Long>)new HashMap<String, Long>(), ObjectType.BIOME, (ResourceLocation)biomeID, (ReqType)reqType, new CompoundTag()).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(Component.literal((String)biomeID.toString()))));
                player.connection.levels().stream().map(ResourceKey::location).forEach(dimID -> core.getCommonReqData((Map<String, Long>)new HashMap<String, Long>(), ObjectType.DIMENSION, (ResourceLocation)dimID, (ReqType)reqType, new CompoundTag()).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(Component.literal((String)dimID.toString()))));
            }
        });
    }

    public static void sendLevelUpUnlocks(String skill, long oldLevel, long level) {
        if (!((Boolean)Config.SKILLUP_UNLOCKS.get()).booleanValue()) {
            return;
        }
        if (cache.isEmpty()) {
            ClientUtils.cacheUnlocks();
        }
        LocalPlayer player = ClientUtils.mc.player;
        Map reqMap = ((Map)cache.getOrDefault(skill, new HashMap())).getOrDefault(level, new HashMap());
        boolean isEmpty = reqMap.entrySet().stream().allMatch(entry -> ((List)entry.getValue()).isEmpty());
        if (isEmpty && ((Boolean)Config.SKILLUP_UNLOCKS_STRICT.get()).booleanValue()) {
            return;
        }
        player.sendSystemMessage((Component)(isEmpty ? LangProvider.LEVEL_UP_HEADER.asComponent(level, Component.translatable((String)("pmmo." + skill))) : LangProvider.LEVEL_UP_HEADER_WITH_UNLOCKS.asComponent(level, Component.translatable((String)("pmmo." + skill)))));
        reqMap.entrySet().stream().filter(entry -> Config.server().requirements().isEnabled((ReqType)entry.getKey()) && !((List)entry.getValue()).isEmpty()).forEach(entry -> {
            MutableComponent header = Component.translatable((String)("pmmo.enum." + ((ReqType)entry.getKey()).name()));
            header.setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            player.sendSystemMessage((Component)header);
            ((List)entry.getValue()).forEach(arg_0 -> ((LocalPlayer)player).sendSystemMessage(arg_0));
        });
    }
}

