/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import harmonised.pmmo.client.gui.component.PMMOButton;
import harmonised.pmmo.client.gui.component.PlayerStatsComponent;
import harmonised.pmmo.config.Config;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;

public class PlayerStatsScreen
extends EffectRenderingInventoryScreen<InventoryMenu> {
    private final PlayerStatsComponent playerStatsComponent = new PlayerStatsComponent();
    public float xMouse;
    public float yMouse;
    public boolean widthTooNarrow;

    public PlayerStatsScreen(Player player) {
        super((AbstractContainerMenu)player.inventoryMenu, player.getInventory(), (Component)Component.translatable((String)"container.crafting"));
        this.titleLabelX = 97;
    }

    protected void init() {
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.playerStatsComponent.init(this.width, this.height, this.minecraft, this.widthTooNarrow);
        this.playerStatsComponent.toggleVisibility();
        this.leftPos = this.playerStatsComponent.updateScreenPosition(this.width, this.imageWidth);
        this.addRenderableWidget((GuiEventListener)new PMMOButton((Screen)this, this.leftPos + (Integer)Config.SKILL_BUTTON_X.get() - 22, this.height / 2 + (Integer)Config.SKILL_BUTTON_Y.get(), 20, 18));
        this.addWidget((GuiEventListener)this.playerStatsComponent);
    }

    protected void containerTick() {
        this.playerStatsComponent.tick();
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.playerStatsComponent.isVisible() && this.widthTooNarrow) {
            this.renderBg(graphics, pPartialTick, pMouseX, pMouseY);
            this.playerStatsComponent.render(graphics, pMouseX, pMouseY, pPartialTick);
        } else {
            this.playerStatsComponent.render(graphics, pMouseX, pMouseY, pPartialTick);
            super.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
        this.renderTooltip(graphics, pMouseX, pMouseY);
        this.xMouse = pMouseX;
        this.yMouse = pMouseY;
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partial, int mouseX, int mouseY) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.leftPos;
        int j = this.topPos;
        graphics.blit(INVENTORY_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(i + 26), (int)(j + 8), (int)(i + 75), (int)(j + 78), (int)30, (float)0.06f, (float)mouseX, (float)mouseY, (LivingEntity)this.minecraft.player);
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        return (!this.widthTooNarrow || !this.playerStatsComponent.isVisible()) && super.isHovering(pX, pY, pWidth, pHeight, pMouseX, pMouseY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.playerStatsComponent.mouseClicked(pMouseX, pMouseY, pButton)) {
            this.setFocused((GuiEventListener)this.playerStatsComponent);
            return true;
        }
        return (!this.widthTooNarrow || !this.playerStatsComponent.isVisible()) && super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.playerStatsComponent.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta, double other) {
        if (this.playerStatsComponent.mouseScrolled(pMouseX, pMouseY, pDelta, other)) {
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pDelta, other);
    }

    public PlayerStatsComponent getPlayerStatsComponent() {
        return this.playerStatsComponent;
    }
}

