/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api.enums;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;

public enum ObjectType implements StringRepresentable
{
    ITEM,
    BLOCK,
    ENTITY,
    DIMENSION,
    BIOME,
    ENCHANTMENT,
    EFFECT,
    PLAYER;

    public static final Codec<ObjectType> CODEC;
    private static final Map<String, ObjectType> BY_NAME;

    public static ObjectType byName(String name) {
        return BY_NAME.get(name);
    }

    public String getSerializedName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(ObjectType::values);
        BY_NAME = Arrays.stream(ObjectType.values()).collect(Collectors.toMap(ObjectType::getSerializedName, s -> s));
    }
}

