/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.playertracking_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class Tracking {
    int mx;
    int my;
    int mz;

    public void setLoc(int x, int y, int z) {
        this.mx = x;
        this.my = y;
        this.mz = z;
    }

    public boolean checkPlayer(Player pl, int x, int z) {
        BlockPos pos = pl.blockPosition();
        if (x == 0) {
            int plz = pos.getZ();
            int num = Math.abs(z);
            if (Math.abs(this.mz - plz) < num) {
                if (z < 0) {
                    return plz < this.mz;
                }
                return plz > this.mz;
            }
        } else if (z == 0) {
            int plz = pos.getX();
            int num = Math.abs(x);
            if (Math.abs(this.mx - plz) < num) {
                if (x < 0) {
                    return plz < this.mx;
                }
                return plz > this.mx;
            }
        }
        return false;
    }

    public void TrackDir(Player player, int x, int z, Player player2) {
        String compass = "West";
        List plist = player.level().players();
        ArrayList<Player> in = new ArrayList<Player>();
        int num = Math.abs(x) + Math.abs(z);
        if (player2 == null) {
            for (Player value : plist) {
                if (!this.checkPlayer(value, x, z)) continue;
                in.add(value);
            }
        } else if (this.checkPlayer(player2, x, z)) {
            in.add(player2);
        }
        if (z < 0) {
            compass = "North";
        } else if (z > 0) {
            compass = "South";
        }
        if (x < 0) {
            compass = "West";
        } else if (x > 0) {
            compass = "East";
        }
        StringBuilder str = new StringBuilder();
        for (Player value : in) {
            str.append(value.getName()).append(",");
        }
        MessageFunctions.sendMessage((Player)player, (String)(compass + "<" + num + ">: " + String.valueOf(str)), (ChatFormatting)ChatFormatting.GRAY);
    }

    public int findBlock(Level world, int x, int z, Block block1, Block block2) {
        boolean hasmat = true;
        int length = 0;
        for (int i = 1; i < 10000; ++i) {
            BlockPos bpos = new BlockPos(this.mx + x * i, this.my, this.mz + z * i);
            Block block = world.getBlockState(bpos).getBlock();
            if (!hasmat) continue;
            if (block.equals(block1)) {
                ++length;
                if (!block1.equals(Blocks.COBBLESTONE)) continue;
                world.setBlockAndUpdate(bpos, Blocks.AIR.defaultBlockState());
                continue;
            }
            if (block.equals(block2)) {
                hasmat = false;
                ++length;
                if (!block1.equals(Blocks.COBBLESTONE)) break;
                world.setBlockAndUpdate(bpos, Blocks.AIR.defaultBlockState());
                break;
            }
            return 0;
        }
        if (length > 0 && !hasmat) {
            return length;
        }
        return 0;
    }

    public void Track(Block block1, Block block2, Player player, Player player2) {
        Level world = player.level();
        BlockPos bpos = player.blockPosition().below().immutable();
        Block block = world.getBlockState(bpos).getBlock();
        int northDist = this.findBlock(world, -1, 0, block1, block2);
        int southDist = this.findBlock(world, 1, 0, block1, block2);
        int eastDist = this.findBlock(world, 0, -1, block1, block2);
        int westDist = this.findBlock(world, 0, 1, block1, block2);
        MessageFunctions.sendMessage((Player)player, (String)"Tracking Data:     (Use F3 for directions)", (ChatFormatting)ChatFormatting.DARK_GRAY);
        if (northDist > 0) {
            this.TrackDir(player, -northDist * 25, 0, player2);
        }
        if (southDist > 0) {
            this.TrackDir(player, southDist * 25, 0, player2);
        }
        if (eastDist > 0) {
            this.TrackDir(player, 0, -eastDist * 25, player2);
        }
        if (westDist > 0) {
            this.TrackDir(player, 0, westDist * 25, player2);
        }
        if (block.equals(Blocks.OBSIDIAN) && northDist + southDist + eastDist + westDist >= 25) {
            world.setBlockAndUpdate(bpos, Blocks.AIR.defaultBlockState());
        }
    }

    public void Track(Player player, Player player2) {
        BlockPos bpos;
        Level world = player.level();
        Block block = world.getBlockState(bpos = player.blockPosition().below().immutable()).getBlock();
        if (block.equals(Blocks.DIAMOND_BLOCK)) {
            this.Track(Blocks.OBSIDIAN, Blocks.GOLD_BLOCK, player, player2);
            return;
        }
        if (block.equals(Blocks.OBSIDIAN)) {
            this.Track(Blocks.COBBLESTONE, Blocks.STONE, player, player2);
            return;
        }
        MessageFunctions.sendMessage((Player)player, (String)"You need to be on a tracking block to do that.", (ChatFormatting)ChatFormatting.GRAY);
        MessageFunctions.sendMessage((Player)player, (String)"Do '/track help' for more information.", (ChatFormatting)ChatFormatting.GRAY);
    }
}

