/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.net;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.net.Message;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.IPipeContainer;
import de.maxhenkel.pipez.gui.containerfactory.PipeContainerProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UpdateFilterMessage
implements Message<UpdateFilterMessage> {
    public static final CustomPacketPayload.Type<UpdateFilterMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pipez", (String)"update_filter"));
    private Filter filter;
    private CompoundTag filterTag;
    private int index;

    public UpdateFilterMessage() {
    }

    public UpdateFilterMessage(Filter filter, int index) {
        this.filter = filter;
        this.index = index;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
        if (!(abstractContainerMenu instanceof IPipeContainer)) {
            return;
        }
        IPipeContainer pipeContainer = (IPipeContainer)abstractContainerMenu;
        PipeType<?, ?>[] pipeTypes = pipeContainer.getPipe().getPipeTypes();
        if (this.index >= pipeTypes.length) {
            return;
        }
        PipeType<?, ?> pipeType = pipeTypes[this.index];
        this.filter = pipeType.createFilter();
        if (this.filter == null) {
            return;
        }
        this.filter = this.filter.fromNbt(this.filterTag);
        List<Filter<?, ?>> filters = pipeContainer.getPipe().getFilters(pipeContainer.getSide(), pipeType);
        Optional<Filter> editFilter = filters.stream().filter(f1 -> this.filter.getId().equals(f1.getId())).findFirst();
        if (editFilter.isPresent()) {
            int index = filters.indexOf(editFilter.get());
            if (index >= 0) {
                filters.set(index, this.filter);
            } else {
                filters.add(this.filter);
            }
        } else {
            filters.add(this.filter);
        }
        pipeContainer.getPipe().setFilters(pipeContainer.getSide(), pipeType, filters);
        PipeContainerProvider.openGui((Player)sender, pipeContainer.getPipe(), pipeContainer.getSide(), this.index, (id, playerInventory, playerEntity) -> new ExtractContainer(id, (Container)playerInventory, pipeContainer.getPipe(), pipeContainer.getSide(), this.index));
    }

    @Override
    public UpdateFilterMessage fromBytes(RegistryFriendlyByteBuf packetBuffer) {
        this.filterTag = packetBuffer.readNbt();
        this.index = packetBuffer.readInt();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf packetBuffer) {
        packetBuffer.writeNbt((Tag)this.filter.toNbt());
        packetBuffer.writeInt(this.index);
    }

    @Override
    public CustomPacketPayload.Type<UpdateFilterMessage> type() {
        return TYPE;
    }
}

