/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.generic;

import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.WindchestBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlockEntity;
import com.finchy.pipeorgans.block.pipes.generic.PedalPipeBlock;
import com.finchy.pipeorgans.init.AllShapes;
import com.finchy.pipeorgans.item.GenericPipeBlockItem;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericPipeBlock
extends Block
implements IBE<GenericPipeBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WALL = WhistleBlock.WALL;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<Generic.WhistleSize> SIZE = EnumProperty.create((String)"size", Generic.WhistleSize.class);
    public int extensionsPerBlock;
    public DeferredHolder<Block, ? extends GenericPipeBlock> baseBlock;
    public DeferredHolder<Block, ? extends GenericExtensionBlock> extensionBlock;
    public Holder<BlockEntityType<?>> blockEntity;

    public GenericPipeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WALL, (Comparable)Boolean.valueOf(false))).setValue(SIZE, (Comparable)((Object)Generic.WhistleSize.MEDIUM)));
        this.extensionsPerBlock = 2;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape whistle = AllShapes.getGenericBase((Generic.WhistleSize)((Object)pState.getValue(SIZE)));
        return Shapes.or((VoxelShape)whistle, (VoxelShape)((Boolean)pState.getValue((Property)WALL) == false ? AllShapes.BASE_FLOOR : AllShapes.getBase((Direction)pState.getValue((Property)FACING))));
    }

    public Class<GenericPipeBlockEntity> getBlockEntityClass() {
        return GenericPipeBlockEntity.class;
    }

    public BlockEntityType<? extends GenericPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)this.blockEntity.value();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)this.blockEntity.value()).create(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WALL, POWERED, SIZE});
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.getItem() == ((GenericPipeBlock)((Object)this.baseBlock.get())).asItem()) {
            this.incrementSize((LevelAccessor)level, pos);
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.getItem() instanceof GenericPipeBlockItem) {
            GenericPipeBlock held = (GenericPipeBlock)((GenericPipeBlockItem)heldItem.getItem()).getBlock();
            if (this.substitutePipe(state, level, pos, held)) {
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                    player.setItemInHand(hand, heldItem);
                    player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)((GenericPipeBlock)((Object)this.baseBlock.get())).asItem()));
                }
                return ItemInteractionResult.SUCCESS;
            }
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)pos);
            player.displayClientMessage((Component)Component.translatable((String)"pipeorgans.blocks.pipes.replace_pipe_deny"), true);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean substitutePipe(BlockState state, Level level, BlockPos pos, GenericPipeBlock held) {
        GenericPipeBlock base = (GenericPipeBlock)state.getBlock();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GenericPipeBlockEntity) {
            GenericPipeBlockEntity be = (GenericPipeBlockEntity)blockEntity;
            if (held.extensionsPerBlock >= base.extensionsPerBlock) {
                int removeDist = (int)Math.ceil((float)be.pitch / (float)base.extensionsPerBlock);
                BlockPos currentPos = pos;
                for (int i = 1; i <= removeDist; ++i) {
                    currentPos = currentPos.above();
                    level.destroyBlock(currentPos, false);
                }
                this.placeNewPipe(state, level, pos, held, be.pitch);
            } else {
                if (be.pitch > 0) {
                    int checkDist = (int)Math.ceil((float)be.pitch / (float)held.extensionsPerBlock);
                    BlockPos currentPos = pos;
                    for (int i = 1; i <= checkDist; ++i) {
                        BlockState currentState = level.getBlockState(currentPos = currentPos.above());
                        if (currentState.canBeReplaced() || currentState.getBlock() instanceof GenericExtensionBlock) continue;
                        return false;
                    }
                    int removeDist = (int)Math.ceil((float)be.pitch / (float)base.extensionsPerBlock);
                    currentPos = pos;
                    for (int i = 1; i <= removeDist; ++i) {
                        currentPos = currentPos.above();
                        level.destroyBlock(currentPos, false);
                    }
                }
                this.placeNewPipe(state, level, pos, held, be.pitch);
            }
        }
        return true;
    }

    public void incrementSize(LevelAccessor level, BlockPos pos) {
        this.incrementSize(level, pos, true);
    }

    public void incrementSize(LevelAccessor pLevel, BlockPos pPos, boolean playSound) {
        BlockState base = pLevel.getBlockState(pPos);
        if (!base.hasProperty(SIZE)) {
            return;
        }
        Generic.WhistleSize size = (Generic.WhistleSize)((Object)base.getValue(SIZE));
        SoundType soundtype = base.getSoundType();
        BlockPos currentPos = pPos.above();
        Direction facing = (Direction)base.getValue((Property)FACING);
        float pVolume = (soundtype.getVolume() + 1.0f) / 2.0f;
        SoundEvent growSound = (SoundEvent)SoundEvents.NOTE_BLOCK_XYLOPHONE.value();
        SoundEvent hitSound = soundtype.getHitSound();
        for (int i = 1; i <= 6; ++i) {
            BlockState blockState = pLevel.getBlockState(currentPos);
            if (blockState.getBlock() instanceof GenericExtensionBlock) {
                if (blockState.getValue(GenericExtensionBlock.SHAPE) == Generic.QuadrupleExtensionShape.DOUBLE) {
                    pLevel.setBlock(currentPos, (BlockState)((BlockState)blockState.setValue(GenericExtensionBlock.SHAPE, (Comparable)((Object)Generic.QuadrupleExtensionShape.QUAD))).setValue((Property)FACING, (Comparable)facing), 3);
                    if (playSound) {
                        float pPitch = (float)Math.pow(2.0, (double)(-(i * 2)) / 12.0);
                        pLevel.playSound(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                        pLevel.playSound(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                    }
                    return;
                }
            } else {
                if (!blockState.canBeReplaced()) {
                    return;
                }
                pLevel.setBlock(currentPos, (BlockState)((BlockState)((GenericExtensionBlock)((Object)this.extensionBlock.get())).defaultBlockState().setValue(SIZE, (Comparable)((Object)size))).setValue((Property)FACING, (Comparable)facing), 3);
                if (playSound) {
                    float pPitch = (float)Math.pow(2.0, (double)(-(i * 2 - 1)) / 12.0);
                    pLevel.playSound(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                    pLevel.playSound(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                }
                return;
            }
            currentPos = currentPos.above();
        }
    }

    public void placeNewPipe(BlockState state, Level level, BlockPos pos, GenericPipeBlock pipe, int pitch) {
        Generic.WhistleSize size = (Generic.WhistleSize)((Object)state.getValue(SIZE));
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean wall = (Boolean)state.getValue((Property)WALL);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        if (pipe instanceof PedalPipeBlock && size == Generic.WhistleSize.TINY) {
            size = Generic.WhistleSize.SMALL;
        }
        level.destroyBlock(pos, false);
        level.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)pipe.defaultBlockState().setValue(SIZE, (Comparable)((Object)size))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)WALL, (Comparable)Boolean.valueOf(wall))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        GenericPipeBlock newPipe = (GenericPipeBlock)level.getBlockState(pos).getBlock();
        if (pitch > 0) {
            for (int i = 1; i <= pitch; ++i) {
                newPipe.incrementSize((LevelAccessor)level, pos);
            }
        }
    }

    public static void queuePitchUpdate(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof GenericPipeBlock) {
            GenericPipeBlock whistle = (GenericPipeBlock)block;
            if (!level.getBlockTicks().hasScheduledTick(pos, (Object)whistle)) {
                level.scheduleTick(pos, (Block)whistle, 1);
            }
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, GenericPipeBlockEntity::updatePitch);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState attachedState = pLevel.getBlockState(pPos.relative(GenericPipeBlock.getAttachedDirection(pState)));
        return FluidTankBlock.isTank((BlockState)attachedState) || attachedState.getBlock() instanceof WindchestBlock;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.cycle(SIZE);
    }

    public static Direction getAttachedDirection(BlockState state) {
        return (Boolean)state.getValue((Property)WALL) != false ? (Direction)state.getValue((Property)FACING) : Direction.DOWN;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state;
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction face = context.getClickedFace();
        boolean wall = true;
        if (face.getAxis() == Direction.Axis.Y) {
            face = context.getHorizontalDirection().getOpposite();
            wall = false;
        }
        if (!this.canSurvive(state = (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)face.getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(clickedPos)))).setValue((Property)WALL, (Comparable)Boolean.valueOf(wall)), (LevelReader)level, clickedPos)) {
            return null;
        }
        return state;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean isMoving) {
        if (pLevel.isClientSide) {
            return;
        }
        boolean previouslyPowered = (Boolean)pState.getValue((Property)POWERED);
        if (previouslyPowered != pLevel.hasNeighborSignal(pPos)) {
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)POWERED), 2);
        }
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return GenericPipeBlock.getAttachedDirection(pState) == pFacing && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : pState;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.relative(GenericPipeBlock.getAttachedDirection(pState)));
        if (pOldState.getBlock() != this || pOldState.getValue(SIZE) != pState.getValue(SIZE)) {
            GenericPipeBlock.queuePitchUpdate((LevelAccessor)pLevel, pPos);
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.relative(GenericPipeBlock.getAttachedDirection(pState)));
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pMirror == Mirror.NONE ? pState : pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }
}

