/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.generic;

import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.init.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class GenericExtensionBlock
extends Block
implements IWrenchable {
    public static final EnumProperty<Generic.QuadrupleExtensionShape> SHAPE = EnumProperty.create((String)"shape", Generic.QuadrupleExtensionShape.class);
    public static final EnumProperty<Generic.WhistleSize> SIZE = GenericPipeBlock.SIZE;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public DeferredHolder<Block, ? extends GenericPipeBlock> baseBlock;

    public GenericExtensionBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)Generic.QuadrupleExtensionShape.DOUBLE))).setValue(SIZE, (Comparable)((Object)Generic.WhistleSize.MEDIUM))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.getGenericExtensionShape((Generic.QuadrupleExtensionShape)((Object)pState.getValue(SHAPE)), (Generic.WhistleSize)((Object)pState.getValue(SIZE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{SHAPE, SIZE, FACING}));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState below = pLevel.getBlockState(pPos.below());
        return below.is((Block)this) && below.getValue(SHAPE) == Generic.QuadrupleExtensionShape.QUAD_CONNECTED || below.getBlock() instanceof GenericPipeBlock;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing.getAxis() != Direction.Axis.Y) {
            return pState;
        }
        if (pFacing == Direction.UP) {
            boolean connected = pState.getValue(SHAPE) == Generic.QuadrupleExtensionShape.QUAD_CONNECTED;
            boolean shouldConnect = pLevel.getBlockState(pCurrentPos.above()).is((Block)this);
            if (!connected && shouldConnect) {
                return (BlockState)pState.setValue(SHAPE, (Comparable)((Object)Generic.QuadrupleExtensionShape.QUAD_CONNECTED));
            }
            if (connected && !shouldConnect) {
                return (BlockState)pState.setValue(SHAPE, (Comparable)((Object)Generic.QuadrupleExtensionShape.QUAD));
            }
            return pState;
        }
        return !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : (BlockState)pState.setValue(SIZE, (Comparable)((Object)((Generic.WhistleSize)((Object)pLevel.getBlockState(pCurrentPos.below()).getValue(SIZE)))));
    }

    public static BlockPos findRoot(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockState;
        BlockPos currentPos = pPos.below();
        while ((blockState = pLevel.getBlockState(currentPos)).getBlock() instanceof GenericExtensionBlock) {
            currentPos = currentPos.below();
        }
        return currentPos;
    }

    protected UseOnContext relocateContext(UseOnContext context, BlockPos target) {
        return new UseOnContext(context.getPlayer(), context.getHand(), new BlockHitResult(context.getClickLocation(), context.getClickedFace(), target, context.isInside()));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() != ((GenericPipeBlock)((Object)this.baseBlock.get())).asItem()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockPos rootFound = GenericExtensionBlock.findRoot((LevelAccessor)level, pos);
        BlockState blockState = level.getBlockState(rootFound);
        Block block = blockState.getBlock();
        if (block instanceof GenericPipeBlock) {
            GenericPipeBlock pipe = (GenericPipeBlock)block;
            return pipe.useItemOn(stack, blockState, level, rootFound, player, hand, new BlockHitResult(hitResult.getLocation(), hitResult.getDirection(), rootFound, hitResult.isInside()));
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (context.getClickLocation().y < (double)((float)context.getClickedPos().getY() + 0.5f) || state.getValue(SHAPE) == Generic.QuadrupleExtensionShape.DOUBLE) {
            return super.onSneakWrenched(state, context);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        world.setBlock(pos, (BlockState)state.setValue(SHAPE, (Comparable)((Object)Generic.QuadrupleExtensionShape.DOUBLE)), 3);
        IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult sneakWrenchedRemove(BlockState state, UseOnContext context) {
        return super.onSneakWrenched(state, context);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos findRoot;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(findRoot = GenericExtensionBlock.findRoot((LevelAccessor)level, context.getClickedPos()));
        Block block = blockState.getBlock();
        if (block instanceof GenericPipeBlock) {
            GenericPipeBlock pipe = (GenericPipeBlock)block;
            return pipe.onWrenched(blockState, this.relocateContext(context, findRoot));
        }
        return super.onWrenched(state, context);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pOldState.getBlock() != this || pOldState.getValue(SHAPE) != pState.getValue(SHAPE)) {
            GenericPipeBlock.queuePitchUpdate((LevelAccessor)pLevel, GenericExtensionBlock.findRoot((LevelAccessor)pLevel, pPos));
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pOldState.getBlock() != this || pOldState.getValue(SHAPE) != pState.getValue(SHAPE)) {
            GenericPipeBlock.queuePitchUpdate((LevelAccessor)pLevel, GenericExtensionBlock.findRoot((LevelAccessor)pLevel, pPos));
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.baseBlock.get());
    }
}

