/*
 * Decompiled with CFR 0.152.
 */
package com.pam.pamhc2crops.world;

import com.pam.pamhc2crops.world.PlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class BiomeModifiers {
    protected static final ResourceKey<BiomeModifier> ARID_GARDEN_PLACED = BiomeModifiers.createKey("arid_garden_placed");
    protected static final ResourceKey<BiomeModifier> FROST_GARDEN_PLACED = BiomeModifiers.createKey("frost_garden_placed");
    protected static final ResourceKey<BiomeModifier> SHADED_GARDEN_PLACED = BiomeModifiers.createKey("shaded_garden_placed");
    protected static final ResourceKey<BiomeModifier> SOGGY_GARDEN_PLACED = BiomeModifiers.createKey("soggy_garden_placed");
    protected static final ResourceKey<BiomeModifier> TROPICAL_GARDEN_PLACED_JUNGLE = BiomeModifiers.createKey("tropical_garden_placed_jungle");
    protected static final ResourceKey<BiomeModifier> TROPICAL_GARDEN_PLACED_OCEAN = BiomeModifiers.createKey("tropical_garden_placed_ocean");
    protected static final ResourceKey<BiomeModifier> WINDY_GARDEN_PLACED_PLAINS = BiomeModifiers.createKey("windy_garden_placed_plains");
    protected static final ResourceKey<BiomeModifier> WINDY_GARDEN_PLACED_SAVANNA = BiomeModifiers.createKey("windy_garden_placed_savanna");

    private static ResourceKey<BiomeModifier> createKey(String path) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pamhc2crops", (String)path));
    }

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderGetter placedGetter = context.lookup(Registries.PLACED_FEATURE);
        context.register(ARID_GARDEN_PLACED, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(Tags.Biomes.IS_DRY_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(PlacedFeatures.ARID_GARDEN_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(FROST_GARDEN_PLACED, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(Tags.Biomes.IS_CONIFEROUS_TREE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(PlacedFeatures.FROST_GARDEN_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(SHADED_GARDEN_PLACED, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(BiomeTags.IS_FOREST), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(PlacedFeatures.SHADED_GARDEN_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(SOGGY_GARDEN_PLACED, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(Tags.Biomes.IS_SWAMP), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(PlacedFeatures.SOGGY_GARDEN_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(TROPICAL_GARDEN_PLACED_JUNGLE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(BiomeTags.IS_JUNGLE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(PlacedFeatures.TROPICAL_GARDEN_PLACED_JUNGLE)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(TROPICAL_GARDEN_PLACED_OCEAN, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(BiomeTags.IS_OCEAN), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(PlacedFeatures.TROPICAL_GARDEN_PLACED_OCEAN)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(WINDY_GARDEN_PLACED_PLAINS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(Tags.Biomes.IS_PLAINS), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(PlacedFeatures.WINDY_GARDEN_PLACED_PLAINS)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(WINDY_GARDEN_PLACED_SAVANNA, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(BiomeTags.IS_SAVANNA), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(PlacedFeatures.WINDY_GARDEN_PLACED_SAVANNA)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }
}

