/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import io.wispforest.owo.Owo;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.neoforged.fml.ModList;

public class SpriteUtilInvoker {
    private static final MethodHandle MARK_SPRITE_ACTIVE = SpriteUtilInvoker.getMarkSpriteActive();

    public static void markSpriteActive(TextureAtlasSprite sprite) {
        try {
            MARK_SPRITE_ACTIVE.invoke(sprite);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodHandle getMarkSpriteActive() {
        if (ModList.get().isLoaded("sodium")) {
            try {
                Class<?> spriteUtil = Class.forName("me.jellysquid.mods.sodium.client.render.texture.SpriteUtil");
                Method m = spriteUtil.getMethod("markSpriteActive", TextureAtlasSprite.class);
                m.setAccessible(true);
                return MethodHandles.lookup().unreflect(m);
            }
            catch (Exception e) {
                Owo.LOGGER.error("Couldn't get SpriteUtil.markSpriteActive from Sodium", (Throwable)e);
            }
        }
        return MethodHandles.empty(MethodType.methodType(Void.TYPE, TextureAtlasSprite.class));
    }
}

