/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network;

import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.RecordEndec;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.mixin.ServerCommonNetworkHandlerAccessor;
import io.wispforest.owo.network.ClientAccess;
import io.wispforest.owo.network.NetworkException;
import io.wispforest.owo.network.OwoClientConnectionExtension;
import io.wispforest.owo.network.OwoHandshake;
import io.wispforest.owo.network.ServerAccess;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.util.OwoFreezer;
import io.wispforest.owo.util.ReflectionUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLLoader;

public class OwoNetChannel {
    static final Map<ResourceLocation, OwoNetChannel> REGISTERED_CHANNELS = new HashMap<ResourceLocation, OwoNetChannel>();
    static final Map<ResourceLocation, OwoNetChannel> REQUIRED_CHANNELS = new HashMap<ResourceLocation, OwoNetChannel>();
    static final Map<ResourceLocation, OwoNetChannel> OPTIONAL_CHANNELS = new HashMap<ResourceLocation, OwoNetChannel>();
    private final ReflectiveEndecBuilder builder;
    private final Map<Class<?>, IndexedEndec<?>> endecsByClass = new HashMap();
    final Int2ObjectMap<IndexedEndec<?>> endecsByIndex = new Int2ObjectOpenHashMap();
    private final List<ChannelHandler<Record, ClientAccess>> clientHandlers = new ArrayList<ChannelHandler<Record, ClientAccess>>();
    private final List<ChannelHandler<Record, ServerAccess>> serverHandlers = new ArrayList<ChannelHandler<Record, ServerAccess>>();
    private final Reference2IntMap<Class<?>> deferredClientEndecs = new Reference2IntOpenHashMap();
    final CustomPacketPayload.Type<MessagePayload> packetId;
    private final String ownerClassName;
    final boolean required;
    private ClientHandle clientHandle = null;
    private ServerHandle serverHandle = null;

    public static OwoNetChannel create(ResourceLocation id) {
        return new OwoNetChannel(id, ReflectionUtils.getCallingClassName(2), true);
    }

    public static OwoNetChannel createOptional(ResourceLocation id) {
        return new OwoNetChannel(id, ReflectionUtils.getCallingClassName(2), false);
    }

    private OwoNetChannel(ResourceLocation id, String ownerClassName, boolean required) {
        OwoFreezer.checkRegister("Network channels");
        this.builder = new ReflectiveEndecBuilder(builder -> {
            builder.register(Endec.VAR_INT, new Class[]{Integer.class, Integer.TYPE});
            builder.register(Endec.VAR_LONG, new Class[]{Long.class, Long.TYPE});
            MinecraftEndecs.addDefaults(builder);
        });
        if (REGISTERED_CHANNELS.containsKey(id)) {
            throw new IllegalStateException("Channel with id '" + String.valueOf(id) + "' was already registered from class '" + OwoNetChannel.REGISTERED_CHANNELS.get((Object)id).ownerClassName + "'");
        }
        this.deferredClientEndecs.defaultReturnValue(-1);
        this.packetId = new CustomPacketPayload.Type(id);
        this.ownerClassName = ownerClassName;
        this.required = required;
        OwoHandshake.enable();
        if (required) {
            OwoHandshake.requireHandshake();
        }
        Endec serverEndec = Endec.dispatched(index -> ((IndexedEndec)this.endecsByIndex.get((Object)index)).endec, msg -> this.endecsByClass.get(msg.getClass()).serverHandlerIndex, (Endec)Endec.VAR_INT).xmap(x -> new MessagePayload(this.packetId, (Record)x), x -> x.message);
        Endec clientEndec = Endec.dispatched(index -> ((IndexedEndec)this.endecsByIndex.get((int)(-index.intValue()))).endec, msg -> this.endecsByClass.get(msg.getClass()).clientHandlerIndex, (Endec)Endec.VAR_INT).xmap(x -> new MessagePayload(this.packetId, (Record)x), x -> x.message);
        PayloadTypeRegistry.playC2S().register(this.packetId, CodecUtils.toPacketCodec(serverEndec));
        PayloadTypeRegistry.playS2C().register(this.packetId, CodecUtils.toPacketCodec(clientEndec));
        ServerPlayNetworking.registerGlobalReceiver(this.packetId, (payload, context) -> this.serverHandlers.get(this.endecsByClass.get(payload.message().getClass()).serverHandlerIndex).handle(payload.message, new ServerAccess(context.player())));
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver(this.packetId, (payload, context) -> this.clientHandlers.get(this.endecsByClass.get(payload.message.getClass()).clientHandlerIndex).handle(payload.message, new ClientAccess(context.player().connection)));
        }
        this.clientHandlers.add(null);
        this.serverHandlers.add(null);
        REGISTERED_CHANNELS.put(id, this);
        if (required) {
            REQUIRED_CHANNELS.put(id, this);
        } else {
            OPTIONAL_CHANNELS.put(id, this);
        }
    }

    public OwoNetChannel addEndecs(Consumer<ReflectiveEndecBuilder> endecBuilder) {
        endecBuilder.accept(this.builder);
        return this;
    }

    public ReflectiveEndecBuilder builder() {
        return this.builder;
    }

    public <R extends Record> void registerClientbound(Class<R> messageClass, ChannelHandler<R, ClientAccess> handler) {
        this.registerClientbound(messageClass, handler, () -> RecordEndec.create((ReflectiveEndecBuilder)this.builder, (Class)messageClass));
    }

    public <R extends Record> void registerClientboundDeferred(Class<R> messageClass) {
        this.registerClientboundDeferred(messageClass, () -> RecordEndec.create((ReflectiveEndecBuilder)this.builder, (Class)messageClass));
    }

    public <R extends Record> void registerServerbound(Class<R> messageClass, ChannelHandler<R, ServerAccess> handler) {
        this.registerServerbound(messageClass, handler, () -> RecordEndec.create((ReflectiveEndecBuilder)this.builder, (Class)messageClass));
    }

    public <R extends Record> void registerClientbound(Class<R> messageClass, StructEndec<R> endec, ChannelHandler<R, ClientAccess> handler) {
        this.registerClientbound(messageClass, handler, () -> endec);
    }

    public <R extends Record> void registerClientboundDeferred(Class<R> messageClass, StructEndec<R> endec) {
        this.registerClientboundDeferred(messageClass, () -> endec);
    }

    public <R extends Record> void registerServerbound(Class<R> messageClass, StructEndec<R> endec, ChannelHandler<R, ServerAccess> handler) {
        this.registerServerbound(messageClass, handler, () -> endec);
    }

    private <R extends Record> void registerClientbound(Class<R> messageClass, ChannelHandler<R, ClientAccess> handler, Supplier<StructEndec<R>> endec) {
        int deferredIndex = this.deferredClientEndecs.removeInt(messageClass);
        if (deferredIndex != -1) {
            OwoFreezer.checkRegister("Network handlers");
            this.clientHandlers.set(deferredIndex, handler);
            return;
        }
        int index = this.clientHandlers.size();
        this.createEndec(messageClass, index, Dist.CLIENT, endec);
        this.clientHandlers.add(handler);
    }

    private <R extends Record> void registerClientboundDeferred(Class<R> messageClass, Supplier<StructEndec<R>> endec) {
        int index = this.clientHandlers.size();
        this.createEndec(messageClass, index, Dist.CLIENT, endec);
        this.clientHandlers.add(null);
        this.deferredClientEndecs.put(messageClass, index);
    }

    private <R extends Record> void registerServerbound(Class<R> messageClass, ChannelHandler<R, ServerAccess> handler, Supplier<StructEndec<R>> endec) {
        int index = this.serverHandlers.size();
        this.createEndec(messageClass, index, Dist.DEDICATED_SERVER, endec);
        this.serverHandlers.add(handler);
    }

    public boolean canSendToPlayer(ServerPlayer player) {
        return this.canSendToPlayer(player.connection);
    }

    public boolean canSendToPlayer(ServerGamePacketListenerImpl networkHandler) {
        if (this.required) {
            return true;
        }
        return OwoHandshake.isValidClient() ? OwoNetChannel.getChannelSet(((ServerCommonNetworkHandlerAccessor)networkHandler).owo$getConnection()).contains(this.packetId.id()) : ServerPlayNetworking.canSend((ServerGamePacketListenerImpl)networkHandler, this.packetId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canSendToServer() {
        if (this.required) {
            return true;
        }
        return OwoHandshake.isValidClient() ? OwoNetChannel.getChannelSet(Minecraft.getInstance().getConnection().getConnection()).contains(this.packetId.id()) : ClientPlayNetworking.canSend(this.packetId);
    }

    private static Set<ResourceLocation> getChannelSet(Connection connection) {
        return ((OwoClientConnectionExtension)connection).owo$getChannelSet();
    }

    public ClientHandle clientHandle() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new NetworkException("Cannot obtain client handle in environment type '" + String.valueOf(FMLLoader.getDist()) + "'");
        }
        if (this.clientHandle == null) {
            this.clientHandle = new ClientHandle();
        }
        return this.clientHandle;
    }

    public ServerHandle serverHandle(MinecraftServer server) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = PlayerLookup.all((MinecraftServer)server);
        return handle;
    }

    public ServerHandle serverHandle(Collection<ServerPlayer> targets) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = targets;
        return handle;
    }

    public ServerHandle serverHandle(Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new NetworkException("'player' must be a 'ServerPlayerEntity'");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerHandle handle = this.getServerHandle();
        handle.targets = Collections.singleton(serverPlayer);
        return handle;
    }

    public ServerHandle serverHandle(BlockEntity entity) {
        if (entity.getLevel().isClientSide) {
            throw new NetworkException("Server handle cannot be obtained on the client");
        }
        return this.serverHandle(PlayerLookup.tracking((BlockEntity)entity));
    }

    public ServerHandle serverHandle(ServerLevel world, BlockPos pos) {
        return this.serverHandle(PlayerLookup.tracking((ServerLevel)world, (BlockPos)pos));
    }

    private ServerHandle getServerHandle() {
        if (this.serverHandle == null) {
            this.serverHandle = new ServerHandle();
        }
        return this.serverHandle;
    }

    private <R extends Record> void createEndec(Class<R> messageClass, int handlerIndex, Dist target, Supplier<StructEndec<R>> supplier) {
        OwoFreezer.checkRegister("Network handlers");
        IndexedEndec<?> endec = this.endecsByClass.get(messageClass);
        if (endec == null) {
            IndexedEndec<R> indexedEndec = IndexedEndec.create(messageClass, supplier.get(), handlerIndex, target);
            this.endecsByClass.put(messageClass, indexedEndec);
            this.endecsByIndex.put(target == Dist.CLIENT ? -handlerIndex : handlerIndex, indexedEndec);
        } else if (endec.handlerIndex(target) == -1) {
            endec.setHandlerIndex(handlerIndex, target);
            this.endecsByIndex.put(target == Dist.CLIENT ? -handlerIndex : handlerIndex, endec);
        } else {
            throw new IllegalStateException("Message class '" + messageClass.getName() + "' is already registered for target environment " + String.valueOf(target));
        }
    }

    private void verify() {
        if (FMLLoader.getDist() == Dist.CLIENT && !this.deferredClientEndecs.isEmpty()) {
            throw new NetworkException("Some deferred client handlers for channel " + String.valueOf(this.packetId) + " haven't been registered: " + this.deferredClientEndecs.keySet().stream().map(Class::getName).collect(Collectors.joining(", ")));
        }
    }

    static {
        OwoFreezer.registerFreezeCallback(() -> {
            for (OwoNetChannel channel : REGISTERED_CHANNELS.values()) {
                channel.verify();
            }
        });
    }

    public class ClientHandle {
        public <R extends Record> void send(R message) {
            ClientPlayNetworking.send((CustomPacketPayload)new MessagePayload(OwoNetChannel.this.packetId, message));
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            for (R message : messages) {
                this.send(message);
            }
        }
    }

    public class ServerHandle {
        private Collection<ServerPlayer> targets = Collections.emptySet();

        public <R extends Record> void send(R message) {
            this.targets.forEach(player -> ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new MessagePayload(OwoNetChannel.this.packetId, message)));
            this.targets = null;
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            this.targets.forEach(player -> {
                for (Record message : messages) {
                    ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new MessagePayload(OwoNetChannel.this.packetId, message));
                }
            });
            this.targets = null;
        }
    }

    public static interface ChannelHandler<R extends Record, E extends EnvironmentAccess<?, ?, ?>> {
        public void handle(R var1, E var2);
    }

    static final class IndexedEndec<R extends Record> {
        private int clientHandlerIndex = -1;
        private int serverHandlerIndex = -1;
        private final Class<R> recordClass;
        private final StructEndec<R> endec;

        private IndexedEndec(Class<R> recordClass, StructEndec<R> endec) {
            this.endec = endec;
            this.recordClass = recordClass;
        }

        public static <R extends Record> IndexedEndec<R> create(Class<R> rClass, StructEndec<R> endec, int index, Dist target) {
            return new IndexedEndec<R>(rClass, endec).setHandlerIndex(index, target);
        }

        public IndexedEndec<R> setHandlerIndex(int index, Dist target) {
            switch (target) {
                case CLIENT: {
                    this.clientHandlerIndex = index;
                    break;
                }
                case DEDICATED_SERVER: {
                    this.serverHandlerIndex = index;
                }
            }
            return this;
        }

        public int handlerIndex(Dist target) {
            return switch (target) {
                default -> throw new MatchException(null, null);
                case Dist.CLIENT -> this.clientHandlerIndex;
                case Dist.DEDICATED_SERVER -> this.serverHandlerIndex;
            };
        }

        public Class<R> getRecordClass() {
            return this.recordClass;
        }
    }

    record MessagePayload(CustomPacketPayload.Type<MessagePayload> id, Record message) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return this.id;
        }
    }

    public static interface EnvironmentAccess<P extends Player, R, N> {
        public P player();

        public R runtime();

        public N netHandler();
    }
}

