/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.portal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class PortalLevelSavedData
extends SavedData {
    private final List<BlockPos> portals;

    public PortalLevelSavedData() {
        this(Collections.emptyList());
    }

    public PortalLevelSavedData(List<BlockPos> entries) {
        this.portals = new ArrayList<BlockPos>(entries);
    }

    public static PortalLevelSavedData load(CompoundTag compound, HolderLookup.Provider provider) {
        return new PortalLevelSavedData(compound.getList("list", 10).stream().filter(tag -> tag instanceof CompoundTag).map(tag -> (CompoundTag)tag).map(entryCompound -> new BlockPos(entryCompound.getInt("x"), entryCompound.getInt("y"), entryCompound.getInt("z"))).collect(Collectors.toList()));
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        this.portals.forEach(pos -> {
            CompoundTag entryCompound = new CompoundTag();
            entryCompound.putInt("x", pos.getX());
            entryCompound.putInt("y", pos.getY());
            entryCompound.putInt("z", pos.getZ());
            list.add((Object)entryCompound);
        });
        compound.put("list", (Tag)list);
        return compound;
    }

    public List<BlockPos> getPortals() {
        return this.portals;
    }
}

