/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.init;

import info.u_team.overworld_mirror.config.NeoForgeCommonConfig;
import info.u_team.overworld_mirror.event.PortalCreationEventHandler;
import info.u_team.overworld_mirror.event.WorldInfoReplaceEventHandler;
import info.u_team.u_team_core.api.construct.Construct;
import info.u_team.u_team_core.api.construct.ModConstruct;
import info.u_team.u_team_core.util.registry.BusRegister;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@Construct(modid="overworldmirror")
public class OverworldMirrorNeoForgeCommonConstruct
implements ModConstruct {
    public void construct() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NeoForgeCommonConfig.CONFIG);
        BusRegister.registerNeoForge(bus -> {
            bus.addListener(EventPriority.NORMAL, false, BonemealEvent.class, event -> {
                Level patt0$temp = event.getLevel();
                if (patt0$temp instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)patt0$temp;
                    Player patt1$temp = event.getPlayer();
                    if (patt1$temp instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)patt1$temp;
                        PortalCreationEventHandler.onBonemeal(event.getPos(), level, player);
                    }
                }
            });
            bus.addListener(EventPriority.NORMAL, false, LevelEvent.Load.class, event -> {
                LevelAccessor patt0$temp = event.getLevel();
                if (patt0$temp instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)patt0$temp;
                    WorldInfoReplaceEventHandler.onWorldLoad(level);
                }
            });
            bus.addListener(EventPriority.NORMAL, false, LevelTickEvent.Post.class, event -> {
                Level patt0$temp = event.getLevel();
                if (patt0$temp instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)patt0$temp;
                    WorldInfoReplaceEventHandler.onWorldTick(level);
                }
            });
        });
    }
}

