/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.block;

import info.u_team.overworld_mirror.init.OverworldMirrorBlocks;
import info.u_team.overworld_mirror.init.OverworldMirrorLevelKeys;
import info.u_team.overworld_mirror.portal.PortalLevelSavedData;
import info.u_team.overworld_mirror.portal.PortalManager;
import info.u_team.u_team_core.block.UBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OverworldMirrorPortalBlock
extends UBlock
implements Portal {
    protected static final VoxelShape SHAPE = OverworldMirrorPortalBlock.box((double)0.0, (double)11.9, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public OverworldMirrorPortalBlock() {
        super(BlockBehaviour.Properties.of().noCollission().strength(-1.0f).sound(SoundType.GLASS).lightLevel(state -> 11).noLootTable().pushReaction(PushReaction.BLOCK));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(false)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    public int getPortalTransitionTime(ServerLevel level, Entity entity) {
        return entity instanceof Player ? 1 : 0;
    }

    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        Object newLevel = level.dimension() == Level.OVERWORLD ? level.getServer().getLevel(OverworldMirrorLevelKeys.MIRROR_OVERWORLD) : (level.dimension() == OverworldMirrorLevelKeys.MIRROR_OVERWORLD ? level.getServer().getLevel(Level.OVERWORLD) : null);
        if (newLevel == null) {
            return null;
        }
        return PortalManager.findOrCreatePortal(newLevel, entity);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PortalLevelSavedData data = PortalManager.getSavedData(serverLevel);
            data.getPortals().removeIf(portal -> portal.equals((Object)pos));
            data.setDirty();
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!fromPos.below().equals((Object)pos) && !fromPos.above().equals((Object)pos) && level.getBlockState(fromPos).getBlock() != OverworldMirrorBlocks.PORTAL.get()) {
            level.removeBlock(pos, isMoving);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }
}

