/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.utils;

import com.benbenlaw.opolisutilities.item.custom.PortableGUIItem;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PortableContainer
extends AbstractContainerMenu {
    private final AbstractContainerMenu originalMenu;

    public PortableContainer(AbstractContainerMenu originalMenu) {
        super(originalMenu.getType(), originalMenu.containerId);
        this.originalMenu = originalMenu;
    }

    public boolean stillValid(@NotNull Player player) {
        if (player.getItemInHand(player.getUsedItemHand()).getItem() instanceof PortableGUIItem) {
            return true;
        }
        return this.originalMenu.stillValid(player);
    }

    public void broadcastChanges() {
        this.originalMenu.broadcastChanges();
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack result = this.originalMenu.quickMoveStack(player, index);
        System.out.println("ItemStack quickMoveStack called with index: " + index);
        return result;
    }

    public void slotsChanged(@NotNull Container inventory) {
        System.out.println("Slots changed in PortableContainer.");
        this.originalMenu.slotsChanged(inventory);
        this.broadcastChanges();
    }

    public void removed(@NotNull Player player) {
        this.originalMenu.removed(player);
    }
}

