/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record CatalogueRecipe(SizedIngredient input, ItemStack output) implements Recipe<RecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.input.ingredient());
        return ingredients;
    }

    public boolean matches(RecipeInput container, @NotNull Level level) {
        if (this.input.test(container.getItem(0))) {
            return container.getItem(0).getCount() >= this.getIngredientStackCount();
        }
        return false;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public int getIngredientStackCount() {
        return this.input.count();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CatalogueRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<CatalogueRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.fieldOf("input").forGetter(CatalogueRecipe::input), (App)ItemStack.CODEC.fieldOf("output").forGetter(CatalogueRecipe::output)).apply((Applicative)instance, CatalogueRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CatalogueRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<CatalogueRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CatalogueRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static CatalogueRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient input = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new CatalogueRecipe(input, output);
        }

        private static void write(RegistryFriendlyByteBuf buffer, CatalogueRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }

    public static class Type
    implements RecipeType<CatalogueRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

