/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.item.custom;

import com.benbenlaw.opolisutilities.block.entity.custom.CatalogueBlockEntity;
import com.benbenlaw.opolisutilities.item.ModDataComponents;
import com.benbenlaw.opolisutilities.screen.custom.CatalogueMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CatalogueBook
extends Item {
    public CatalogueBook(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        CatalogueBlockEntity catalogueBlockEntity;
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        assert (player != null);
        ItemStack itemstack = player.getItemInHand(hand);
        if (!level.isClientSide() && player.isCrouching() && (catalogueBlockEntity = (CatalogueBlockEntity)level.getBlockEntity(blockPos)) instanceof CatalogueBlockEntity && itemstack.getItem() instanceof CatalogueBook) {
            itemstack.set(ModDataComponents.INT_X, (Object)blockPos.getX());
            itemstack.set(ModDataComponents.INT_Y, (Object)blockPos.getY());
            itemstack.set(ModDataComponents.INT_Z, (Object)blockPos.getZ());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!level.isClientSide() && itemstack.getItem() instanceof CatalogueBook) {
            if (itemstack.get(ModDataComponents.INT_X) != null && itemstack.get(ModDataComponents.INT_Y) != null && itemstack.get(ModDataComponents.INT_Z) != null) {
                BlockPos blockPos = new BlockPos(((Integer)itemstack.get(ModDataComponents.INT_X)).intValue(), ((Integer)itemstack.get(ModDataComponents.INT_Y)).intValue(), ((Integer)itemstack.get(ModDataComponents.INT_Z)).intValue());
                BlockEntity blockEntity = level.getBlockEntity(blockPos);
                if (blockEntity instanceof CatalogueBlockEntity) {
                    CatalogueBlockEntity catalogueBlockEntity = (CatalogueBlockEntity)blockEntity;
                    level.getBlockEntity(blockPos);
                    ContainerData data = catalogueBlockEntity.data;
                    player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CatalogueMenu(windowId, playerInventory, blockPos, data), (Component)Component.translatable((String)"block.opolisutilities.catalogue")), buf -> buf.writeBlockPos(blockPos));
                    return InteractionResultHolder.success((Object)itemstack);
                }
                player.sendSystemMessage((Component)Component.translatable((String)"tooltips.catalogue_book.no_catalogue").withStyle(ChatFormatting.RED));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"tooltips.catalogue_book.no_catalogue").withStyle(ChatFormatting.RED));
            }
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltips.portable_gui.shift.held").withStyle(ChatFormatting.GREEN));
            components.add((Component)Component.literal((String)("X: " + String.valueOf(stack.get(ModDataComponents.INT_X)))).withStyle(ChatFormatting.GREEN));
            components.add((Component)Component.literal((String)("Y: " + String.valueOf(stack.get(ModDataComponents.INT_Y)))).withStyle(ChatFormatting.GREEN));
            components.add((Component)Component.literal((String)("Z: " + String.valueOf(stack.get(ModDataComponents.INT_Z)))).withStyle(ChatFormatting.GREEN));
        } else {
            components.add((Component)Component.translatable((String)"tooltips.portable_gui.hover.shift").withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(stack, tooltipContext, components, flag);
    }
}

