/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.item.custom;

import com.benbenlaw.opolisutilities.config.StartupItemConfigFile;
import com.benbenlaw.opolisutilities.item.ModDataComponents;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AnimalNetItem
extends Item {
    public AnimalNetItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, Player player, @NotNull LivingEntity livingEntity, @NotNull InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        assert (player != null);
        ItemStack itemstack = player.getItemInHand(hand);
        BlockPos blockPos = context.getClickedPos();
        if (!level.isClientSide() && itemstack.get((DataComponentType)ModDataComponents.ENTITY_TYPE.get()) != null) {
            EntityType type = EntityType.byString((String)Objects.requireNonNull((String)itemstack.get((DataComponentType)ModDataComponents.ENTITY_TYPE.get()))).orElse(null);
            if (type != null) {
                Entity entity = type.create(level);
                assert (entity != null);
                entity.load(Objects.requireNonNull((CompoundTag)itemstack.get(ModDataComponents.ENTITY_DATA)));
                entity.absMoveTo((double)blockPos.getX() + 0.5, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
                itemstack.remove(ModDataComponents.ENTITY_TYPE);
                itemstack.remove(ModDataComponents.ENTITY_DATA);
                if (((Boolean)StartupItemConfigFile.animalNetTakesDamage.get()).equals(true)) {
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(this.asItem().getDefaultInstance()));
                }
                level.addFreshEntity(entity);
                level.playSound(null, blockPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"tooltips.animal_net.no_mob").withStyle(ChatFormatting.RED));
            }
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            if (stack.get((DataComponentType)ModDataComponents.ENTITY_TYPE.get()) != null) {
                EntityType entity = EntityType.byString((String)Objects.requireNonNull((String)stack.get((DataComponentType)ModDataComponents.ENTITY_TYPE.get()))).orElse(null);
                components.add((Component)Component.translatable((String)"tooltips.animal_net.shift.held").withStyle(ChatFormatting.BLUE));
                components.add((Component)Component.translatable((String)entity.toString()).withStyle(ChatFormatting.GREEN));
            } else {
                boolean hostileMobs = (Boolean)StartupItemConfigFile.animalNetHostileMobs.get();
                boolean waterMobs = (Boolean)StartupItemConfigFile.animalNetWaterMobs.get();
                boolean animalMobs = (Boolean)StartupItemConfigFile.animalNetAnimalMobs.get();
                boolean villagerMobs = (Boolean)StartupItemConfigFile.animalNetVillagerMobs.get();
                components.add((Component)Component.translatable((String)"tooltips.animal_net.mob_types").withStyle(ChatFormatting.BLUE));
                if (hostileMobs) {
                    components.add((Component)Component.translatable((String)"tooltips.animal_net.hostile_mobs").withStyle(ChatFormatting.GREEN));
                }
                if (waterMobs) {
                    components.add((Component)Component.translatable((String)"tooltips.animal_net.water_mobs").withStyle(ChatFormatting.GREEN));
                }
                if (animalMobs) {
                    components.add((Component)Component.translatable((String)"tooltips.animal_net.animal_mobs").withStyle(ChatFormatting.GREEN));
                }
                if (villagerMobs) {
                    components.add((Component)Component.translatable((String)"tooltips.animal_net.villager_mobs").withStyle(ChatFormatting.GREEN));
                }
                components.add((Component)Component.translatable((String)"tooltips.animal_net.no_mob").withStyle(ChatFormatting.RED));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltips.animal_net.hover.shift").withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(stack, tooltipContext, components, flag);
    }
}

