/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.recipe.SoakingTableRecipe;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoakingTableRecipeCategory
implements IRecipeCategory<SoakingTableRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"soaking_table");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/jei_drying_table.png");
    static final RecipeType<SoakingTableRecipe> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"soaking_table", SoakingTableRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    @Nullable
    public ResourceLocation getRegistryName(SoakingTableRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)SoakingTableRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((SoakingTableRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public SoakingTableRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 120, 19);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.DRYING_TABLE.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public RecipeType<SoakingTableRecipe> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.SOAKING_TABLE;
    }

    public Component getTitle() {
        return Component.literal((String)"Soaking Table");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SoakingTableRecipe recipe, IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 2).addIngredients((Ingredient)recipe.getIngredients().get(0));
        assert (false);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 2).addItemStack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }

    public void draw(SoakingTableRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        int duration = recipe.getDuration();
        guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)(duration / 20 + "s")), 95, 6, Color.WHITE.getRGB());
    }
}

