/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.recipe.ResourceGeneratorRecipe;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceGeneratorRecipeCategory
implements IRecipeCategory<ResourceGeneratorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"resource_generator");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/jei_dynamic.png");
    static final RecipeType<ResourceGeneratorRecipe> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"resource_generator", ResourceGeneratorRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private final int tabs = 1;
    private int tabs_used = 0;

    @Nullable
    public ResourceLocation getRegistryName(ResourceGeneratorRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ResourceGeneratorRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((ResourceGeneratorRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public ResourceGeneratorRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 175, 57);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.RESOURCE_GENERATOR.get()));
    }

    @NotNull
    public RecipeType<ResourceGeneratorRecipe> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.RESOURCE_GENERATOR;
    }

    public boolean isHandled(ResourceGeneratorRecipe recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Resource Generator");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ResourceGeneratorRecipe recipe, @NotNull IFocusGroup focusGroup) {
        ++this.tabs_used;
        ArrayList<ResourceGeneratorRecipe> recipes = new ArrayList<ResourceGeneratorRecipe>(Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ResourceGeneratorRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList());
        ArrayList<ResourceGeneratorRecipe> mutableRecipes = new ArrayList<ResourceGeneratorRecipe>(recipes);
        int numRows = (int)Math.ceil((double)mutableRecipes.size() / 9.0);
        int numCols = Math.min(9, mutableRecipes.size());
        int backgroundWidth = 4 + numCols * 19;
        int backgroundHeight = 2 + numRows * 19;
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, backgroundWidth, backgroundHeight);
        for (int i = 0; i < mutableRecipes.size(); ++i) {
            int slotX = 4 + i % 9 * 19;
            int slotY = 2 + i / 9 * 19;
            builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addIngredients(((ResourceGeneratorRecipe)mutableRecipes.get(i)).input());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, slotX, slotY).addIngredients(((ResourceGeneratorRecipe)mutableRecipes.get(i)).input())).setBackground((IDrawable)JEIOpolisUtilitiesPlugin.slotDrawable, slotX - i % 9 * 19 - 5, slotY - (2 + i / 9 * 19) - 1);
        }
    }
}

