/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.datagen.recipes;

import com.benbenlaw.opolisutilities.recipe.SummoningBlockRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummoningRecipeBuilder
implements RecipeBuilder {
    protected String group;
    protected SizedIngredient input;
    protected Ingredient catalyst;
    String mob;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public SummoningRecipeBuilder(SizedIngredient input, Ingredient catalyst, String mob) {
        this.input = input;
        this.catalyst = catalyst;
        this.mob = mob;
    }

    public static SummoningRecipeBuilder SummoningRecipeBuilder(SizedIngredient input, Ingredient catalyst, String mob) {
        return new SummoningRecipeBuilder(input, catalyst, mob);
    }

    @NotNull
    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    @NotNull
    public Item getResult() {
        return ItemStack.EMPTY.getItem();
    }

    public void save(@NotNull RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"summoning/"));
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        SummoningBlockRecipe summoningBlockRecipe = new SummoningBlockRecipe(this.input, this.catalyst, this.mob);
        recipeOutput.accept(id, (Recipe)summoningBlockRecipe, builder.build(id.withPrefix("recipes/summoning/")));
    }
}

