/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.custom.DryingTableBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.handler.InputOutputItemHandler;
import com.benbenlaw.opolisutilities.recipe.DryingTableRecipe;
import com.benbenlaw.opolisutilities.recipe.SoakingTableRecipe;
import com.benbenlaw.opolisutilities.screen.custom.DryingTableMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryingTableBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            DryingTableBlockEntity.this.setChanged();
            DryingTableBlockEntity.this.sync();
        }
    };
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 80;
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private final IItemHandler dryingTableItemHandlerSide = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
    private final IItemHandler noSideItemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> false, i -> false);

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    public ItemStack getRenderStack() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).isEmpty() ? this.itemHandler.getStackInSlot(0) : this.itemHandler.getStackInSlot(1);
        return stack;
    }

    public IItemHandler getItemHandlerCapability(Direction side) {
        return this.dryingTableItemHandlerSide;
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public DryingTableBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.DRYING_TABLE_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> DryingTableBlockEntity.this.progress;
                    case 1 -> DryingTableBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        DryingTableBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        DryingTableBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        if (((Boolean)this.getBlockState().getValue((Property)DryingTableBlock.WATERLOGGED)).booleanValue()) {
            return Component.translatable((String)"block.opolisutilities.soaking_table");
        }
        return Component.translatable((String)"block.opolisutilities.drying_table");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new DryingTableMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        BlockPos blockPos = this.worldPosition;
        DryingTableBlockEntity blockEntity = this;
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.sync();
            RecipeInput inventory = new RecipeInput(){

                @NotNull
                public ItemStack getItem(int index) {
                    return DryingTableBlockEntity.this.itemHandler.getStackInSlot(index);
                }

                public int size() {
                    return DryingTableBlockEntity.this.itemHandler.getSlots();
                }
            };
            Optional match = this.level.getRecipeManager().getRecipeFor((RecipeType)DryingTableRecipe.Type.INSTANCE, inventory, this.level);
            Optional matchSoaking = this.level.getRecipeManager().getRecipeFor((RecipeType)SoakingTableRecipe.Type.INSTANCE, inventory, this.level);
            if (!((Boolean)this.getBlockState().getValue((Property)DryingTableBlock.WATERLOGGED)).booleanValue() && match.isPresent()) {
                this.maxProgress = ((DryingTableRecipe)((RecipeHolder)match.get()).value()).getDuration();
                ++this.progress;
                if (this.progress >= this.maxProgress && this.canInsertItemIntoOutputSlot(inventory, ((DryingTableRecipe)((RecipeHolder)match.get()).value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess())) && this.hasOutputSpaceMaking(this, (DryingTableRecipe)((RecipeHolder)match.get()).value()) && this.hasCorrectCountInInputSlot(this, (DryingTableRecipe)((RecipeHolder)match.get()).value()) && this.hasDuration((DryingTableRecipe)((RecipeHolder)match.get()).value())) {
                    this.craftItem(this);
                    this.setChanged();
                }
            } else if (((Boolean)this.getBlockState().getValue((Property)DryingTableBlock.WATERLOGGED)).booleanValue() && matchSoaking.isPresent()) {
                this.maxProgress = ((SoakingTableRecipe)((RecipeHolder)matchSoaking.get()).value()).getDuration();
                ++this.progress;
                if (this.progress >= this.maxProgress && this.canInsertItemIntoOutputSlot(inventory, ((SoakingTableRecipe)((RecipeHolder)matchSoaking.get()).value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess())) && this.hasOutputSpaceMakingSoaking(this, (SoakingTableRecipe)((RecipeHolder)matchSoaking.get()).value()) && this.hasCorrectCountInInputSlotSoaking(this, (SoakingTableRecipe)((RecipeHolder)matchSoaking.get()).value()) && this.hasDurationSoaking((SoakingTableRecipe)((RecipeHolder)matchSoaking.get()).value())) {
                    this.craftItem(this);
                    this.setChanged();
                    this.sync();
                }
            } else {
                this.resetProgress();
                this.setChanged();
                this.sync();
            }
        }
    }

    private void craftItem(@NotNull DryingTableBlockEntity entity) {
        Level level = entity.level;
        assert (level != null);
        if (!level.isClientSide()) {
            Optional matchSoaking;
            RecipeInput inventory = new RecipeInput(){

                @NotNull
                public ItemStack getItem(int index) {
                    return DryingTableBlockEntity.this.itemHandler.getStackInSlot(index);
                }

                public int size() {
                    return DryingTableBlockEntity.this.itemHandler.getSlots();
                }
            };
            Optional match = level.getRecipeManager().getRecipeFor((RecipeType)DryingTableRecipe.Type.INSTANCE, inventory, level);
            if (match.isPresent() && !((Boolean)entity.getBlockState().getValue((Property)DryingTableBlock.WATERLOGGED)).booleanValue()) {
                entity.itemHandler.extractItem(0, ((DryingTableRecipe)((RecipeHolder)match.get()).value()).getIngredientStackCount(), false);
                ItemStack resultItem = new ItemStack((ItemLike)((DryingTableRecipe)((RecipeHolder)match.get()).value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess()).getItem(), entity.itemHandler.getStackInSlot(1).getCount() + ((DryingTableRecipe)((RecipeHolder)match.get()).value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess()).getCount());
                DataComponentMap resultItemWithDataComponents = ((DryingTableRecipe)((RecipeHolder)match.get()).value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess()).getComponents();
                resultItem.applyComponents(resultItemWithDataComponents);
                entity.itemHandler.setStackInSlot(1, resultItem);
            }
            if ((matchSoaking = level.getRecipeManager().getRecipeFor((RecipeType)SoakingTableRecipe.Type.INSTANCE, inventory, level)).isPresent() && ((Boolean)entity.getBlockState().getValue((Property)DryingTableBlock.WATERLOGGED)).booleanValue()) {
                entity.itemHandler.extractItem(0, ((SoakingTableRecipe)((RecipeHolder)matchSoaking.get()).value()).getIngredientStackCount(), false);
                ItemStack resultItem = new ItemStack((ItemLike)((SoakingTableRecipe)((RecipeHolder)matchSoaking.get()).value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess()).getItem(), entity.itemHandler.getStackInSlot(1).getCount() + ((SoakingTableRecipe)((RecipeHolder)matchSoaking.get()).value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess()).getCount());
                DataComponentMap resultItemWithDataComponents = ((SoakingTableRecipe)((RecipeHolder)matchSoaking.get()).value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess()).getComponents();
                resultItem.applyComponents(resultItemWithDataComponents);
                entity.itemHandler.setStackInSlot(1, resultItem);
            }
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasDuration(DryingTableRecipe recipe) {
        return 0 <= recipe.duration();
    }

    private boolean hasDurationSoaking(SoakingTableRecipe recipe) {
        return 0 <= recipe.getDuration();
    }

    private boolean canInsertItemIntoOutputSlot(RecipeInput inventory, ItemStack output) {
        return inventory.getItem(1).getItem() == output.getItem() || inventory.getItem(1).isEmpty();
    }

    private boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.getItem(1).getMaxStackSize() > inventory.getItem(1).getCount();
    }

    private boolean hasCorrectCountInInputSlot(DryingTableBlockEntity entity, DryingTableRecipe recipe) {
        return entity.itemHandler.getStackInSlot(0).getCount() >= recipe.getIngredientStackCount();
    }

    private boolean hasCorrectCountInInputSlotSoaking(DryingTableBlockEntity entity, SoakingTableRecipe recipe) {
        return entity.itemHandler.getStackInSlot(0).getCount() >= recipe.getIngredientStackCount();
    }

    private boolean hasOutputSpaceMaking(DryingTableBlockEntity entity, DryingTableRecipe recipe) {
        ItemStack outputSlotStack = entity.itemHandler.getStackInSlot(1);
        ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess());
        if (outputSlotStack.isEmpty()) {
            return resultStack.getCount() <= resultStack.getMaxStackSize();
        }
        if (outputSlotStack.getItem() == resultStack.getItem()) {
            return outputSlotStack.getCount() + resultStack.getCount() <= outputSlotStack.getMaxStackSize();
        }
        return false;
    }

    private boolean hasOutputSpaceMakingSoaking(DryingTableBlockEntity entity, SoakingTableRecipe recipe) {
        ItemStack outputSlotStack = entity.itemHandler.getStackInSlot(1);
        ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)Objects.requireNonNull(this.getLevel()).registryAccess());
        if (outputSlotStack.isEmpty()) {
            return resultStack.getCount() <= resultStack.getMaxStackSize();
        }
        if (outputSlotStack.getItem() == resultStack.getItem()) {
            return outputSlotStack.getCount() + resultStack.getCount() <= outputSlotStack.getMaxStackSize();
        }
        return false;
    }
}

