/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.custom;

import com.benbenlaw.opolisutilities.particles.ModParticles;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderOreBlock
extends Block {
    public static final MapCodec<EnderOreBlock> CODEC = EnderOreBlock.simpleCodec(EnderOreBlock::new);
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;

    public EnderOreBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.FALSE);
    }

    protected void attack(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        EnderOreBlock.interact(blockState, level, blockPos);
        super.attack(blockState, level, blockPos, player);
    }

    public void stepOn(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (!entity.isSteppingCarefully()) {
            EnderOreBlock.interact(blockState, level, blockPos);
        }
        super.stepOn(level, blockPos, blockState, entity);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos p_316592_, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            EnderOreBlock.spawnParticles(level, p_316592_);
        } else {
            EnderOreBlock.interact(blockState, level, p_316592_);
        }
        return itemStack.getItem() instanceof BlockItem && new BlockPlaceContext(player, hand, itemStack, hitResult).canPlace() ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.SUCCESS;
    }

    private static void interact(BlockState blockState, Level level, BlockPos blockPos) {
        EnderOreBlock.spawnParticles(level, blockPos);
        if (!((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)LIT, (Comparable)Boolean.TRUE), 3);
        }
    }

    protected boolean isRandomlyTicking(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)LIT);
    }

    protected void randomTick(BlockState blockState, @NotNull ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)LIT, (Comparable)Boolean.FALSE), 3);
        }
    }

    protected void spawnAfterBreak(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull ItemStack itemStack, boolean dropExperience) {
        super.spawnAfterBreak(blockState, level, blockPos, itemStack, dropExperience);
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity breaker, ItemStack tool) {
        return 1 + level.getRandom().nextInt(5);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            EnderOreBlock.spawnParticles(level, blockPos);
        }
    }

    private static void spawnParticles(Level level, BlockPos blockPosWorld) {
        RandomSource randomsource = level.random;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = blockPosWorld.relative(direction);
            if (level.getBlockState(blockpos).isSolidRender((BlockGetter)level, blockpos)) continue;
            Direction.Axis direction$axis = direction.getAxis();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)randomsource.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.getStepY() : (double)randomsource.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)randomsource.nextFloat();
            level.addParticle((ParticleOptions)ModParticles.ENDER_ORE_PARTICLES.get(), (double)blockPosWorld.getX() + d1, (double)blockPosWorld.getY() + d2, (double)blockPosWorld.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }
}

