/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.emi.impl.render;

import com.klikli_dev.occultism.client.gui.spirit.SpiritGui;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class SpiritWidget<T extends SpiritEntity>
extends Widget {
    private int x;
    private int y;
    private int s;
    private T spiritEntity;
    private EntityType<T> spiritType;
    private BiFunction<Integer, Integer, List<ClientTooltipComponent>> tooltipSupplier = (mouseX, mouseY) -> List.of();

    public SpiritWidget(int x, int y, EntityType<T> spiritType, int s) {
        this.x = x;
        this.y = y;
        this.s = s;
        this.spiritType = spiritType;
    }

    public Bounds getBounds() {
        return new Bounds(this.x - 15, 0, 30, 30);
    }

    public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        if (this.spiritEntity == null) {
            this.spiritEntity = (SpiritEntity)this.spiritType.create((Level)Minecraft.getInstance().level);
        }
        SpiritGui.drawEntityToGui(draw, this.x, (int)((float)this.y + this.spiritEntity.getEyeHeight() * 15.0f), this.s, 1.0f, 1.0f, this.spiritEntity);
    }

    public SpiritWidget tooltip(BiFunction<Integer, Integer, List<ClientTooltipComponent>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        return this.tooltipSupplier.apply(mouseX, mouseY);
    }
}

