/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.emi.impl.recipes;

import com.klikli_dev.occultism.common.entity.spirit.FoliotEntity;
import com.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.klikli_dev.occultism.integration.emi.impl.OccultismEmiPlugin;
import com.klikli_dev.occultism.integration.emi.impl.render.SpiritWidget;
import com.klikli_dev.occultism.registry.OccultismEntities;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CrushingRecipeCategory
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final Integer min;
    private final Integer max;
    private static final List<EmiIngredient> tiers = List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_marid_crusher")))})), EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_afrit_crusher")))})), EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_djinni_crusher")))})), EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_foliot_crusher")))})));

    public CrushingRecipeCategory(RecipeHolder<CrushingRecipe> recipe) {
        this.id = recipe.id();
        this.min = ((CrushingRecipe)recipe.value()).getMinTier();
        this.max = ((CrushingRecipe)recipe.value()).getMaxTier();
        this.input = List.of(EmiIngredient.of((Ingredient)((Ingredient)((CrushingRecipe)recipe.value()).getIngredients().get(0))));
        this.output = List.of(EmiStack.of((ItemStack)((CrushingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
    }

    public EmiRecipeCategory getCategory() {
        return OccultismEmiPlugin.CRUSHING_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public int getDisplayWidth() {
        return 110;
    }

    public int getDisplayHeight() {
        return 30;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        Object spiritType;
        widgetHolder.addSlot(this.input.get(0), 0, 7);
        widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 18, 7);
        int y = 0;
        int s = 12;
        if (this.getMin() <= 1) {
            y = 10;
            s = 16;
            spiritType = OccultismEntities.FOLIOT.get();
        } else {
            spiritType = this.getMin() == 2 ? OccultismEntities.DJINNI.get() : (this.getMin() == 3 ? OccultismEntities.AFRIT.get() : OccultismEntities.MARID.get());
        }
        SpiritWidget widget = new SpiritWidget<FoliotEntity>(53, y, (EntityType<FoliotEntity>)spiritType, s).tooltip((mouseX, mouseY) -> {
            ArrayList<ClientTextTooltip> tooltip = new ArrayList<ClientTextTooltip>();
            if (this.getMin() >= 1) {
                tooltip.add(new ClientTextTooltip(Component.translatable((String)"jei.occultism.crushing.min_tier", (Object[])new Object[]{this.getMin()}).getVisualOrderText()));
            }
            if (this.getMax() >= 1) {
                tooltip.add(new ClientTextTooltip(Component.translatable((String)"jei.occultism.crushing.max_tier", (Object[])new Object[]{this.getMax()}).getVisualOrderText()));
            }
            return tooltip;
        });
        widgetHolder.add((Widget)widget);
        widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 64, 7);
        widgetHolder.addSlot((EmiIngredient)this.output.get(0), 90, 7).recipeContext((EmiRecipe)this);
    }

    public List<EmiIngredient> getCatalysts() {
        return tiers;
    }
}

