/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipe;

import com.klikli_dev.occultism.datagen.recipe.builders.MinerRecipeBuilder;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;

public abstract class MinerRecipes
extends RecipeProvider {
    public MinerRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(p_248933_, lookupProvider);
    }

    public static void ores(RecipeOutput recipeOutput) {
        MinerRecipes.makeOreRecipe("uraninite_poor", 750, recipeOutput);
        MinerRecipes.makeOreRecipe("uraninite_regular", 500, recipeOutput);
        MinerRecipes.makeOreRecipe("uraninite_dense", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("sal_ammoniac", 750, recipeOutput);
        MinerRecipes.makeOreRecipe("dark_gem", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("agate", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("aluminum", 422, recipeOutput);
        MinerRecipes.makeOreRecipe("amber", 184, recipeOutput);
        MinerRecipes.makeOreRecipe("amethyst", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("antimony", 80, recipeOutput);
        MinerRecipes.makeOreRecipe("aquamarine", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("ardite", 159, recipeOutput);
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ORES, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/arcane_crystal")), 200).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/ores/arcane_crystal"));
        MinerRecipes.makeOreRecipe("bauxite", 168, recipeOutput);
        MinerRecipes.makeOreRecipe("beryl", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("boron", 199, recipeOutput);
        MinerRecipes.makeOreRecipe("certus_quartz", 187, recipeOutput);
        MinerRecipes.makeOreRecipe("cinnabar", 190, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.CLAY, 300, recipeOutput);
        MinerRecipes.makeVanillaOreRecipe("coal", 1000, recipeOutput);
        MinerRecipes.makeOreRecipe("cobalt", 163, recipeOutput);
        MinerRecipes.makeVanillaOreRecipe("copper", 584, recipeOutput);
        MinerRecipes.makeVanillaOreRecipe("diamond", 218, recipeOutput);
        MinerRecipes.makeOreRecipe("electrotine", 155, recipeOutput);
        MinerRecipes.makeVanillaOreRecipe("emerald", 156, recipeOutput);
        MinerRecipes.makeOreRecipe("fluorite", 133, recipeOutput);
        MinerRecipes.makeOreRecipe("garnet", 200, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.GLOWSTONE, 234, recipeOutput);
        MinerRecipes.makeVanillaOreRecipe("gold", 311, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.GRAVEL, 300, recipeOutput);
        MinerRecipes.makeOreRecipe("heliodor", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("indicolite", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("inferium", 190, recipeOutput);
        MinerRecipes.makeOreRecipe("iolite", 200, recipeOutput);
        MinerRecipes.makeVanillaOreRecipe("iron", 750, recipeOutput);
        MinerRecipes.makeVanillaOreRecipe("iridium", 40, recipeOutput);
        MinerRecipes.makeVanillaOreRecipe("lapis", 343, recipeOutput);
        MinerRecipes.makeOreRecipe("lead", 500, recipeOutput);
        MinerRecipes.makeOreRecipe("lignite_coal", 212, recipeOutput);
        MinerRecipes.makeOreRecipe("lithium", 201, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.MAGMA_BLOCK, 300, recipeOutput);
        MinerRecipes.makeOreRecipe("magnesium", 233, recipeOutput);
        MinerRecipes.makeOreRecipe("malachite", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("mithril", 169, recipeOutput);
        MinerRecipes.makeOreRecipe("morganite", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("monazite", 48, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.GILDED_BLACKSTONE, 373, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.NETHER_GOLD_ORE, 373, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.NETHER_QUARTZ_ORE, 560, recipeOutput);
        MinerRecipes.makeOreRecipe("nickel", 232, recipeOutput);
        MinerRecipes.makeOreRecipe("niter", 244, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.OBSIDIAN, 300, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.CRYING_OBSIDIAN, 50, recipeOutput);
        MinerRecipes.makeOreRecipe("onyx", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("opal", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("osmium", 203, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(((Block)OccultismBlocks.OTHERSTONE.get()).asItem(), 50, recipeOutput);
        MinerRecipes.makeOreRecipe("peridot", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("platinum", 150, recipeOutput);
        MinerRecipes.makeOreRecipe("prosperity", 155, recipeOutput);
        MinerRecipes.makeVanillaItemRecipe(Items.REDSTONE_ORE, 515, recipeOutput);
        MinerRecipes.makeOreRecipe("ruby", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("salt", 160, recipeOutput);
        MinerRecipes.makeOreRecipe("sapphire", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("silver", 381, recipeOutput);
        MinerRecipes.makeOreRecipe("sulfur", 222, recipeOutput);
        MinerRecipes.makeOreRecipe("tanzanite", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("thorium", 222, recipeOutput);
        MinerRecipes.makeOreRecipe("tin", 602, recipeOutput);
        MinerRecipes.makeOreRecipe("titanium", 10, recipeOutput);
        MinerRecipes.makeOreRecipe("topaz", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("tungsten", 192, recipeOutput);
        MinerRecipes.makeOreRecipe("uranium", 140, recipeOutput);
        MinerRecipes.makeOreRecipe("uraninite", 140, recipeOutput);
        MinerRecipes.makeOreRecipe("dimensional_shard", 127, recipeOutput);
        MinerRecipes.makeOreRecipe("draconium", 142, recipeOutput);
        MinerRecipes.makeOreRecipe("bone_fragments", 302, recipeOutput);
        MinerRecipes.makeOreRecipe("baronyte", 260, recipeOutput);
        MinerRecipes.makeOreRecipe("blazium", 218, recipeOutput);
        MinerRecipes.makeOreRecipe("bloodstone", 160, recipeOutput);
        MinerRecipes.makeOreRecipe("blue_gemstone", 300, recipeOutput);
        MinerRecipes.makeOreRecipe("charged_runium", 142, recipeOutput);
        MinerRecipes.makeOreRecipe("crystallite", 500, recipeOutput);
        MinerRecipes.makeOreRecipe("elecanium", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("emberstone", 302, recipeOutput);
        MinerRecipes.makeOreRecipe("gemenyte", 400, recipeOutput);
        MinerRecipes.makeOreRecipe("ghastly", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("ghoulish", 180, recipeOutput);
        MinerRecipes.makeOreRecipe("green_gemstone", 300, recipeOutput);
        MinerRecipes.makeOreRecipe("jade", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("jewelyte", 370, recipeOutput);
        MinerRecipes.makeOreRecipe("limonite", 400, recipeOutput);
        MinerRecipes.makeOreRecipe("lyon", 160, recipeOutput);
        MinerRecipes.makeOreRecipe("mystite", 280, recipeOutput);
        MinerRecipes.makeOreRecipe("ornamyte", 280, recipeOutput);
        MinerRecipes.makeOreRecipe("purple_gemstone", 300, recipeOutput);
        MinerRecipes.makeOreRecipe("red_gemstone", 300, recipeOutput);
        MinerRecipes.makeOreRecipe("runium", 300, recipeOutput);
        MinerRecipes.makeOreRecipe("shyregem", 302, recipeOutput);
        MinerRecipes.makeOreRecipe("shyrestone", 302, recipeOutput);
        MinerRecipes.makeOreRecipe("varsium", 200, recipeOutput);
        MinerRecipes.makeOreRecipe("white_gemstone", 300, recipeOutput);
        MinerRecipes.makeOreRecipe("yellow_gemstone", 300, recipeOutput);
        MinerRecipes.makeOreRecipe("black_quartz", 360, recipeOutput);
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ORES, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/xpetrified_ore")), 200).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/ores/xpetrified_ore"));
        MinerRecipes.makeOreRecipe("zinc", 186, recipeOutput);
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ORES, MinerRecipes.tag("forbidden_arcanus:runic_stones"), 200).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/ores/runic_stone"));
    }

    public static void eldritch(RecipeOutput recipeOutput) {
        MinerRecipes.makeStorageRecipe("raw_aethersent", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_allthemodium", 30, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_aluminum", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_azure_silver", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_antimony", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_cloggrum", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_cobalt", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_copper", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_crimson_iron", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_froststeel", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_gold", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_iesnium", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_iridium", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_iron", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_lead", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_nickel", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_osmium", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_platinum", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_silver", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_tin", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_tungsten", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_titanium", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_unobtainium", 10, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_uranium", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_vibranium", 20, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_yellorium", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("raw_zinc", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("arcane_crystal", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("bauxite", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("coal", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("dark_gem", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("diamond", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("emerald", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("fluorite", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("inferium_essence", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("jade", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("lapis", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("lignite_coal", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("monazite", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("onyx", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("peridot", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("prosperity_shard", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("redstone", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("ruby", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("rune", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("salt", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("sapphire", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("sulfur", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("soulium_dust", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("stellarite", 90, recipeOutput);
        MinerRecipes.makeStorageRecipe("uraninite", 90, recipeOutput);
        MinerRecipes.makeGemEldritchOutputRecipe("sal_ammoniac", 90, 9, recipeOutput);
        MinerRecipes.makeGemEldritchOutputRecipe("amethyst", 90, 9, recipeOutput);
        MinerRecipes.makeGemEldritchOutputRecipe("quartz", 90, 9, recipeOutput);
        MinerRecipes.makeGemEldritchOutputRecipe("black_quartz", 90, 9, recipeOutput);
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ELDRITCH, (TagKey<Item>)Tags.Items.ORES_NETHERITE_SCRAP, 90, 9).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/eldritch/ancient_debris"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ELDRITCH, (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, 90, 9).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/eldritch/glowstone_dust"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ELDRITCH, OccultismTags.Items.CLAY, 90, 9).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/eldritch/clay"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ELDRITCH, OccultismItems.MINING_DIMENSION_CORE_PIECE, 1).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/eldritch/mining_dim_core"));
    }

    public static void makeVanillaItemRecipe(Item type, int weight, RecipeOutput consumer) {
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ORES, (ItemLike)type, weight).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("miner/ores/" + MinerRecipes.getItemName((ItemLike)type))));
    }

    public static void makeVanillaOreRecipe(String type, int weight, RecipeOutput consumer) {
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ORES, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ores/" + type))), weight).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("miner/ores/" + type + "_ore")));
    }

    public static void makeOreRecipe(String type, int weight, RecipeOutput consumer) {
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ORES, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ores/" + type))), weight).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("miner/ores/" + type + "_ore")));
    }

    public static void makeStorageRecipe(String type, int weight, RecipeOutput consumer) {
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ELDRITCH, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + type))), weight).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("miner/eldritch/" + type)));
    }

    public static void makeGemEldritchOutputRecipe(String type, int weight, int amount, RecipeOutput consumer) {
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.ELDRITCH, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("gems/" + type))), weight, amount).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("miner/eldritch/" + type)));
    }

    public static void deeps(RecipeOutput consumer) {
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.DEEPS, (ItemLike)Items.DEEPSLATE_COAL_ORE, 1000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/deeps/deepslate_coal_ore"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.DEEPS, (ItemLike)Items.DEEPSLATE_COPPER_ORE, 584).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/deeps/deepslate_copper_ore"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.DEEPS, (ItemLike)Items.DEEPSLATE_DIAMOND_ORE, 218).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/deeps/deepslate_diamond_ore"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.DEEPS, (ItemLike)Items.DEEPSLATE_EMERALD_ORE, 156).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/deeps/deepslate_emerald_ore"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.DEEPS, (ItemLike)Items.DEEPSLATE_GOLD_ORE, 311).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/deeps/deepslate_gold_ore"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.DEEPS, (ItemLike)Items.DEEPSLATE_IRON_ORE, 750).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/deeps/deepslate_iron_ore"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.DEEPS, (ItemLike)Items.DEEPSLATE_LAPIS_ORE, 343).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/deeps/deepslate_lapis_ore"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.DEEPS, (ItemLike)Items.DEEPSLATE_REDSTONE_ORE, 515).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/deeps/deepslate_redstone_ore"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.DEEPS, (ItemLike)OccultismBlocks.SILVER_ORE_DEEPSLATE.get(), 381).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/deeps/deepslate_silver_ore"));
    }

    public static void master_resources(RecipeOutput consumer) {
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.MASTER, (ItemLike)Items.ANCIENT_DEBRIS, 100).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/master/ancient_debris"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.MASTER, (ItemLike)OccultismBlocks.IESNIUM_ORE.get(), 100).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/master/iesnium_ore"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.MASTER, OccultismItems.MINING_DIMENSION_CORE_PIECE, 1).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/master/mining_dim_core"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.MASTER, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/stellarite")), 50).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/master/stellarite"));
    }

    public static void basic_resources(RecipeOutput consumer) {
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.STONE, 10000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/stone"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.ANDESITE, 7000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/andesite"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.DIORITE, 7000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/diorite"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.GRANITE, 7000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/granite"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.DEEPSLATE, 5000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/deepslate"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.MOSSY_COBBLESTONE, 3000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/mossy_cobblestone"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.MOSSY_STONE_BRICKS, 3000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/mossy_stone_bricks"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.NETHERRACK, 1000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/netherrack"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.BASALT, 1000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/basalt"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.BLACKSTONE, 1000).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/blackstone"));
        MinerRecipeBuilder.minerRecipe(OccultismTags.Items.Miners.BASIC_RESOURCES, (ItemLike)Items.END_STONE, 30).unlockedBy("has_miner", MinerRecipes.has((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().save(consumer, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"miner/basic_resources/end_stone"));
    }

    public static TagKey<Item> tag(String tag) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag));
    }

    protected void buildRecipes(RecipeOutput consumer) {
    }
}

