/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book.pentacles;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookSpiritFireRecipePageModel;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ParaphernaliaEntry
extends EntryProvider {
    public static final String ENTRY_ID = "paraphernalia";

    public ParaphernaliaEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Paraphernalia");
        this.pageText("In addition to runes various occult paraphernalia are used to improve the intended effect of the pentacle.\n");
        this.page("candle", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.LARGE_CANDLE.asItem()})).withText(this.context().pageText()));
        this.pageText("Candles increase the stability of the pentacle, thus allowing a slowed essence decay of the summoned\n spirit, leading to a longer lifetime of the spirit, or possessed object or being.\n");
        this.page("skull", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.SKELETON_SKULL})).withText(this.context().pageText()));
        this.pageText("Skulls increase the calling power of the pentacle, allowing to summon more dangerous spirits.\\\n\\\nOccultists can find an easy way to obtain these skulls using basic possession rituals.\n");
        this.page("crystal", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.asItem()})).withText(this.context().pageText()));
        this.pageText("Crystals increase the stability of the pentacle, at levels that candles would not reach, allowing a performing more unstable rituals.\\\n\\\nCheck the recipes in next page.\n");
        this.page("recipe_gem", () -> (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem")));
        this.page("recipe_crystal", () -> (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/spirit_attuned_crystal")));
        this.page("wither_skull", () -> BookSpotlightPageModel.create().withItem(Items.WITHER_SKELETON_SKULL).withText(this.context().pageText()));
        this.pageText("Whiter Skulls are stronger than regular Skull, and increase a lot the calling power of the pentacle,\n allowing to summon more powerful class of spirits.\\\n\\\nOccultists can find an easy way to obtain these skulls using wild rituals.\n");
    }

    protected String entryName() {
        return "Occult Paraphernalia";
    }

    protected String entryDescription() {
        return "Stability and Power";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)Blocks.SKELETON_SKULL);
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

