/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.ritual;

import com.google.common.base.Suppliers;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.advancement.RitualTrigger;
import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.blockentity.SacrificialBowlBlockEntity;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.ConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.ConditionWrapperFactory;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.RitualRecipeConditionContext;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.RitualRecipeConditionFailureInformationVisitor;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismParticles;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismSounds;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public abstract class Ritual {
    public static final int SACRIFICIAL_BOWL_RANGE = 8;
    public static final int SACRIFICE_DETECTION_RANGE = 8;
    public static final int SACRIFICE_DETECTION_RANGE_SQUARE = 64;
    public static final int ITEM_USE_DETECTION_RANGE = 16;
    public static final int ITEM_USE_DETECTION_RANGE_SQUARE = 256;
    public RitualRecipe recipe;
    public ResourceLocation factoryId;
    Supplier<RecipeHolder<RitualRecipe>> recipeHolderSupplier;

    public Ritual(RitualRecipe recipe) {
        this.recipe = recipe;
    }

    public static List<Ingredient> getRemainingAdditionalIngredients(List<Ingredient> additionalIngredients, List<ItemStack> consumedIngredients) {
        ArrayList<ItemStack> consumedIngredientsCopy = new ArrayList<ItemStack>(consumedIngredients);
        ArrayList<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
        for (Ingredient ingredient : additionalIngredients) {
            Optional<ItemStack> matchedStack = consumedIngredientsCopy.stream().filter(arg_0 -> ((Ingredient)ingredient).test(arg_0)).findFirst();
            if (matchedStack.isPresent()) {
                consumedIngredientsCopy.remove(matchedStack.get());
                continue;
            }
            remainingAdditionalIngredients.add(ingredient);
        }
        return remainingAdditionalIngredients;
    }

    public ResourceLocation getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryId(ResourceLocation factoryId) {
        this.factoryId = factoryId;
    }

    public RitualRecipe getRecipe() {
        return this.recipe;
    }

    public RecipeHolder<RitualRecipe> getRecipeHolder(Level level) {
        if (this.recipeHolderSupplier == null) {
            this.recipeHolderSupplier = Suppliers.memoize(() -> level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> r.value() == this.getRecipe()).findFirst().orElse(null));
        }
        return this.recipeHolderSupplier.get();
    }

    public String getRitualID(ServerPlayer player) {
        RecipeHolder<RitualRecipe> holder = this.getRecipeHolder(player.level());
        if (holder == null) {
            return "unknown";
        }
        ResourceLocation recipeId = holder.id();
        String path = recipeId.getPath();
        if (path.contains("/")) {
            path = path.substring(path.indexOf("/") + 1);
        }
        return recipeId.getNamespace() + "." + path;
    }

    public String getConditionsMessage(ServerPlayer player) {
        return String.format("ritual.%s.conditions", this.getRitualID(player));
    }

    public String getStartedMessage(ServerPlayer player) {
        return String.format("ritual.%s.started", this.getRitualID(player));
    }

    public String getInterruptedMessage(ServerPlayer player) {
        return String.format("ritual.%s.interrupted", this.getRitualID(player));
    }

    public MutableComponent getConditionNotMetMessage(GoldenSacrificialBowlBlockEntity bowl, ServerPlayer player) {
        RitualRecipeConditionFailureInformationVisitor visitor = new RitualRecipeConditionFailureInformationVisitor();
        ConditionWrapper<?> condition = ConditionWrapperFactory.wrap(this.recipe.getCondition());
        if (condition == null) {
            return Component.literal((String)"Unknown condition");
        }
        return condition.accept(visitor, RitualRecipeConditionContext.of(bowl));
    }

    public String getFinishedMessage(ServerPlayer player) {
        return String.format("ritual.%s.finished", this.getRitualID(player));
    }

    public boolean isValid(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable Player castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients) {
        return this.recipe.getPentacle() != null && this.recipe.getActivationItem().test(activationItem) && this.areAdditionalIngredientsFulfilled(level, goldenBowlPosition, remainingAdditionalIngredients) && this.recipe.getPentacle().validate(level, goldenBowlPosition) != null;
    }

    public boolean start(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable ServerPlayer castingPlayer, ItemStack activationItem) {
        level.playSound(null, goldenBowlPosition, OccultismSounds.START_RITUAL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (this.recipe.getCondition() != null) {
            RitualRecipeConditionContext context = RitualRecipeConditionContext.of(blockEntity);
            if (!this.recipe.getCondition().test((ICondition.IContext)context)) {
                if (castingPlayer != null) {
                    castingPlayer.displayClientMessage((Component)this.getConditionNotMetMessage(blockEntity, castingPlayer), false);
                }
                return false;
            }
        }
        if (castingPlayer != null) {
            castingPlayer.displayClientMessage((Component)Component.translatable((String)this.getStartedMessage(castingPlayer)), true);
        }
        return true;
    }

    public void finish(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable ServerPlayer castingPlayer, ItemStack activationItem) {
        level.playSound(null, goldenBowlPosition, OccultismSounds.POOF.get(), SoundSource.BLOCKS, 0.7f, 0.7f);
        if (castingPlayer != null) {
            castingPlayer.displayClientMessage((Component)Component.translatable((String)this.getFinishedMessage(castingPlayer)), true);
            ((RitualTrigger)((Object)OccultismAdvancements.RITUAL.get())).trigger(castingPlayer, this);
        }
    }

    public void interrupt(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable ServerPlayer castingPlayer, ItemStack activationItem, boolean showMessage) {
        level.playSound(null, goldenBowlPosition, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 0.7f, 0.7f);
        if (castingPlayer != null && showMessage) {
            castingPlayer.displayClientMessage((Component)Component.translatable((String)this.getInterruptedMessage(castingPlayer)), true);
        }
    }

    public void update(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable Player castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients, int time) {
    }

    public void update(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable Player castingPlayer, ItemStack activationItem, int time) {
        this.update(level, goldenBowlPosition, blockEntity, castingPlayer, activationItem, new ArrayList<Ingredient>(), time);
    }

    public boolean identify(Level level, BlockPos goldenBowlPosition, ItemStack activationItem) {
        return this.recipe.getPentacle() != null && this.recipe.getActivationItem().test(activationItem) && this.areAdditionalIngredientsFulfilled(level, goldenBowlPosition, (List<Ingredient>)this.recipe.getIngredients()) && this.recipe.getPentacle().validate(level, goldenBowlPosition) != null;
    }

    public boolean consumeAdditionalIngredients(Level level, BlockPos goldenBowlPosition, List<Ingredient> remainingAdditionalIngredients, int time, List<ItemStack> consumedIngredients) {
        int ingredientsConsumed;
        if (remainingAdditionalIngredients.isEmpty()) {
            return true;
        }
        int totalIngredientsToConsume = (int)Math.floor((float)time / this.recipe.getDurationPerIngredient());
        int ingredientsToConsume = totalIngredientsToConsume - (ingredientsConsumed = consumedIngredients.size());
        if (ingredientsToConsume == 0) {
            return true;
        }
        List<SacrificialBowlBlockEntity> sacrificialBowls = this.getSacrificialBowls(level, goldenBowlPosition);
        Iterator<Ingredient> it = remainingAdditionalIngredients.iterator();
        for (int consumed = 0; it.hasNext() && consumed < ingredientsToConsume; ++consumed) {
            Ingredient ingredient = it.next();
            if (!this.consumeAdditionalIngredient(level, goldenBowlPosition, sacrificialBowls, ingredient, consumedIngredients)) {
                return false;
            }
            it.remove();
        }
        return true;
    }

    public boolean consumeAdditionalIngredient(Level level, BlockPos goldenBowlPosition, List<SacrificialBowlBlockEntity> sacrificialBowls, Ingredient ingredient, List<ItemStack> consumedIngredients) {
        for (SacrificialBowlBlockEntity sacrificialBowl : sacrificialBowls) {
            ItemStack stack = sacrificialBowl.itemStackHandler.extractItem(0, 1, true);
            if (!ingredient.test(stack)) continue;
            ItemStack extracted = sacrificialBowl.itemStackHandler.extractItem(0, 1, false);
            consumedIngredients.add(extracted);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)sacrificialBowl.getBlockPos().getX() + 0.5, (double)sacrificialBowl.getBlockPos().getY() + 1.5, (double)sacrificialBowl.getBlockPos().getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            level.playSound(null, sacrificialBowl.getBlockPos(), OccultismSounds.POOF.get(), SoundSource.BLOCKS, 0.7f, 0.7f);
            return true;
        }
        return false;
    }

    public void markNextIngredient(Level level, BlockPos goldenBowlPosition, Ingredient ingredient, int tier) {
        List<SacrificialBowlBlockEntity> sacrificialBowls = this.getSacrificialBowls(level, goldenBowlPosition);
        for (SacrificialBowlBlockEntity sacrificialBowl : sacrificialBowls) {
            ItemStack stack = sacrificialBowl.itemStackHandler.extractItem(0, 1, true);
            if (!ingredient.test(stack)) continue;
            double gameTime = (double)level.getGameTime() * 0.05;
            double sin = Math.sin(gameTime) * 0.3;
            double cos = Math.cos(gameTime) * 0.3;
            Vec3 center = sacrificialBowl.getBlockPos().getCenter();
            ((ServerLevel)level).sendParticles((ParticleOptions)OccultismParticles.SPIRIT_FIRE_FLAME.get(), center.x + cos, center.y + 0.2 + cos, center.z + sin, 1, 0.0, 0.0, 0.0, 0.003);
            if (tier == 2) {
                double sin2 = Math.sin(gameTime + 1.5707963267948966) * 0.3;
                double cos2 = Math.cos(gameTime + 1.5707963267948966) * 0.3;
                ((ServerLevel)level).sendParticles((ParticleOptions)OccultismParticles.SPIRIT_FIRE_FLAME.get(), center.x + cos2, center.y + 0.2 + sin2, center.z + sin2, 1, 0.0, 0.0, 0.0, 0.003);
                ((ServerLevel)level).sendParticles((ParticleOptions)OccultismParticles.SPIRIT_FIRE_FLAME.get(), center.x - cos2, center.y + 0.2 + cos2, center.z - sin2, 1, 0.0, 0.0, 0.0, 0.003);
                ((ServerLevel)level).sendParticles((ParticleOptions)OccultismParticles.SPIRIT_FIRE_FLAME.get(), center.x - cos, center.y + 0.2 + sin, center.z - sin, 1, 0.0, 0.0, 0.0, 0.003);
            }
            return;
        }
    }

    public boolean areAdditionalIngredientsFulfilled(Level level, BlockPos goldenBowlPosition, List<Ingredient> additionalIngredients) {
        return this.matchesAdditionalIngredients(additionalIngredients, this.getItemsOnSacrificialBowls(level, goldenBowlPosition));
    }

    public boolean matchesAdditionalIngredients(List<Ingredient> additionalIngredients, List<ItemStack> items) {
        if (((Boolean)Occultism.SERVER_CONFIG.rituals.enableRemainingIngredientCountMatching.get()).booleanValue() && additionalIngredients.size() != items.size()) {
            return false;
        }
        if (additionalIngredients.isEmpty()) {
            return true;
        }
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>(items);
        for (Ingredient ingredient : additionalIngredients) {
            boolean isMatched = false;
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack stack = (ItemStack)remainingItems.get(i);
                if (!ingredient.test(stack)) continue;
                isMatched = true;
                remainingItems.remove(i);
                break;
            }
            if (isMatched) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> getItemsOnSacrificialBowls(Level level, BlockPos goldenBowlPosition) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<SacrificialBowlBlockEntity> sacrificialBowls = this.getSacrificialBowls(level, goldenBowlPosition);
        for (SacrificialBowlBlockEntity sacrificialBowl : sacrificialBowls) {
            ItemStack stack = sacrificialBowl.itemStackHandler.getStackInSlot(0);
            if (stack.isEmpty()) continue;
            result.add(stack);
        }
        return result;
    }

    public List<SacrificialBowlBlockEntity> getSacrificialBowls(Level level, BlockPos goldenBowlPosition) {
        Multiblock pentacle = this.recipe.getPentacle();
        Vec3i offset = pentacle.getOffset();
        Vec3i size = pentacle.getSize();
        int yBowlRangeTop = size.getY() - offset.getY() - 1;
        int yBowlRangeBottom = offset.getY();
        ArrayList<SacrificialBowlBlockEntity> result = new ArrayList<SacrificialBowlBlockEntity>();
        Iterable blocksToCheck = BlockPos.betweenClosed((BlockPos)goldenBowlPosition.offset(-8, -(++yBowlRangeBottom), -8), (BlockPos)goldenBowlPosition.offset(8, ++yBowlRangeTop, 8));
        for (BlockPos blockToCheck : blocksToCheck) {
            BlockEntity blockEntity = level.getBlockEntity(blockToCheck);
            if (!(blockEntity instanceof SacrificialBowlBlockEntity) || blockEntity instanceof GoldenSacrificialBowlBlockEntity) continue;
            result.add((SacrificialBowlBlockEntity)blockEntity);
        }
        return result;
    }

    public boolean isValidSacrifice(LivingEntity entity) {
        return entity != null && this.recipe.requiresSacrifice() && entity.getType().is(this.recipe.getEntityToSacrifice());
    }

    public boolean isValidItemUse(PlayerInteractEvent.RightClickItem event) {
        return this.recipe.requiresItemUse() && this.recipe.getItemToUse().test(event.getItemStack());
    }

    public boolean requiresSacrifice() {
        return this.recipe.requiresSacrifice();
    }

    public boolean require() {
        return this.recipe.requiresItemUse();
    }

    public void dropResult(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable Player castingPlayer, ItemStack stack) {
        double angle = level.random.nextDouble() * Math.PI * 2.0;
        ItemEntity entity = new ItemEntity(level, (double)goldenBowlPosition.getX() + 0.5, (double)goldenBowlPosition.getY() + 0.75, (double)goldenBowlPosition.getZ() + 0.5, stack);
        entity.setDeltaMovement(Math.sin(angle) * 0.125, 0.25, Math.cos(angle) * 0.125);
        entity.setPickUpDelay(10);
        level.addFreshEntity((Entity)entity);
    }
}

