/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.ritual;

import com.klikli_dev.occultism.common.advancement.RitualTrigger;
import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.spirit.demonicpartner.DemonicPartner;
import com.klikli_dev.occultism.common.ritual.SummonRitual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.occultism.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ResurrectFamiliarRitual
extends SummonRitual {
    public ResurrectFamiliarRitual(RitualRecipe recipe) {
        super(recipe, true);
    }

    @Override
    public void finish(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable ServerPlayer castingPlayer, ItemStack activationItem) {
        level.playSound(null, goldenBowlPosition, OccultismSounds.POOF.get(), SoundSource.BLOCKS, 0.7f, 0.7f);
        if (castingPlayer != null) {
            castingPlayer.displayClientMessage((Component)Component.translatable((String)this.getFinishedMessage(castingPlayer)), true);
            ((RitualTrigger)((Object)OccultismAdvancements.RITUAL.get())).trigger(castingPlayer, this);
        }
        ItemStack shard = activationItem.copy();
        activationItem.shrink(1);
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)goldenBowlPosition.getX() + 0.5, (double)goldenBowlPosition.getY() + 0.5, (double)goldenBowlPosition.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        if (shard.has(DataComponents.ENTITY_DATA)) {
            CompoundTag entityData = ((CustomData)shard.get(DataComponents.ENTITY_DATA)).getUnsafe();
            EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
            BlockPos spawnPos = goldenBowlPosition;
            entityData.remove("Pos");
            CompoundTag wrapper = new CompoundTag();
            wrapper.put("EntityTag", (Tag)entityData);
            Entity entity = type.create(level);
            entity.load(entityData);
            entity.absMoveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
            level.addFreshEntity(entity);
            if (entity instanceof FamiliarEntity) {
                FamiliarEntity familiar = (FamiliarEntity)entity;
                if (castingPlayer != null) {
                    familiar.setFamiliarOwner((LivingEntity)castingPlayer);
                }
            }
            if (entity instanceof DemonicPartner) {
                DemonicPartner partner = (DemonicPartner)entity;
                if (castingPlayer != null) {
                    partner.setOwnerUUID(castingPlayer.getUUID());
                }
            }
        }
    }
}

