/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.misc;

import com.klikli_dev.occultism.api.common.container.IItemStackComparator;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ItemStackComparator
implements IItemStackComparator {
    protected ItemStack filterStack;
    protected boolean matchNbt;

    public ItemStackComparator(ItemStack stack) {
        this(stack, false);
    }

    public ItemStackComparator(ItemStack filterStack, boolean matchNbt) {
        this.filterStack = filterStack;
        this.matchNbt = matchNbt;
    }

    private ItemStackComparator() {
    }

    public static ItemStackComparator from(CompoundTag nbt, HolderLookup.Provider provider) {
        ItemStackComparator comparator = new ItemStackComparator();
        comparator.deserializeNBT(provider, nbt);
        return !comparator.filterStack.isEmpty() ? comparator : null;
    }

    public boolean getMatchNbt() {
        return this.matchNbt;
    }

    public void setMatchNbt(boolean matchNbt) {
        this.matchNbt = matchNbt;
    }

    public ItemStack getFilterStack() {
        return this.filterStack;
    }

    public void setFilterStack(@Nonnull ItemStack filterStack) {
        this.filterStack = filterStack;
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (this.matchNbt && !ItemStack.isSameItemSameComponents((ItemStack)this.filterStack, (ItemStack)stack)) {
            return false;
        }
        return stack.getItem() == this.filterStack.getItem();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.write(new CompoundTag(), provider);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.read(nbt, provider);
    }

    public void read(CompoundTag compound, HolderLookup.Provider provider) {
        CompoundTag nbt = compound.getCompound("stack");
        this.filterStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt);
        this.matchNbt = compound.getBoolean("matchNbt");
    }

    public CompoundTag write(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("stack", this.filterStack.saveOptional(provider));
        compound.putBoolean("matchNbt", this.matchNbt);
        return compound;
    }
}

