/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.spirit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.klikli_dev.occultism.common.container.spirit.SpiritContainer;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.ISkinnedCreatureMixin;
import com.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrain;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;

public abstract class SpiritEntity
extends TamableAnimal
implements ISkinnedCreatureMixin,
MenuProvider,
SmartBrainOwner<SpiritEntity> {
    public static final EntityDataAccessor<Integer> SKIN = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final int DEFAULT_MAX_AGE = -1;
    public static final int MAX_FILTER_SLOTS = 14;
    protected static final EntityDataAccessor<String> JOB_ID = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Optional<BlockPos>> DEPOSIT_POSITION = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Optional<UUID>> DEPOSIT_ENTITY_UUID = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Direction> DEPOSIT_FACING = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Optional<BlockPos>> EXTRACT_POSITION = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Direction> EXTRACT_FACING = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Optional<BlockPos>> WORK_AREA_POSITION = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Integer> WORK_AREA_SIZE = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SPIRIT_AGE = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SPIRIT_MAX_AGE = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_FILTER_BLACKLIST = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<CompoundTag> FILTER_ITEMS = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<String> TAG_FILTER = SynchedEntityData.defineId(SpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public ItemStackHandler inventory;
    public ItemStackHandler filterItemStackHandler = new ItemStackHandler(14){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SpiritEntity.this.entityData.set(FILTER_ITEMS, (Object)this.serializeNBT((HolderLookup.Provider)SpiritEntity.this.level().registryAccess()));
        }
    };
    protected Optional<SpiritJob> job;
    protected boolean isInitialized = false;

    public SpiritEntity(EntityType<? extends SpiritEntity> type, Level worldIn) {
        this(type, worldIn, new ItemStackHandler(1));
    }

    public SpiritEntity(EntityType<? extends SpiritEntity> type, Level worldIn, ItemStackHandler inventory) {
        super(type, worldIn);
        this.inventory = inventory;
        this.setPersistenceRequired();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_SPEED, 4.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.FOLLOW_RANGE, 50.0);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this, true);
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
    }

    public void handleAdditionalBrainSetup(SmartBrain<? extends SpiritEntity> brain) {
        this.getJob().ifPresent(job -> job.handleAdditionalBrainSetup((Brain<? extends SpiritEntity>)brain));
    }

    public List<ExtendedSensor<SpiritEntity>> getSensors() {
        return this.getJob().isPresent() ? this.getJob().get().getSensors() : ImmutableList.of();
    }

    public BrainActivityGroup<SpiritEntity> getCoreTasks() {
        return this.getJob().isPresent() ? this.getJob().get().getCoreTasks() : BrainActivityGroup.empty();
    }

    public BrainActivityGroup<SpiritEntity> getIdleTasks() {
        return this.getJob().isPresent() ? this.getJob().get().getIdleTasks() : BrainActivityGroup.empty();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        CompoundTag compound;
        super.onSyncedDataUpdated(key);
        if (key == FILTER_ITEMS && this.level().isClientSide && !(compound = (CompoundTag)this.entityData.get(FILTER_ITEMS)).isEmpty()) {
            this.filterItemStackHandler.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compound);
        }
    }

    public Optional<BlockPos> getDepositPosition() {
        return (Optional)this.entityData.get(DEPOSIT_POSITION);
    }

    public void setDepositPosition(BlockPos position) {
        this.entityData.set(DEPOSIT_POSITION, Optional.ofNullable(position));
        if (position != null) {
            this.entityData.set(DEPOSIT_ENTITY_UUID, Optional.empty());
        }
        BrainUtils.setMemory((LivingEntity)this, OccultismMemoryTypes.DEPOSIT_POSITION.get(), (Object)position);
    }

    public Optional<UUID> getDepositEntityUUID() {
        return (Optional)this.entityData.get(DEPOSIT_ENTITY_UUID);
    }

    public void setDepositEntityUUID(UUID uuid) {
        this.entityData.set(DEPOSIT_ENTITY_UUID, Optional.ofNullable(uuid));
        if (uuid != null) {
            this.entityData.set(DEPOSIT_POSITION, Optional.empty());
        }
    }

    public Optional<BlockPos> getExtractPosition() {
        return (Optional)this.entityData.get(EXTRACT_POSITION);
    }

    public void setExtractPosition(BlockPos position) {
        this.entityData.set(EXTRACT_POSITION, Optional.ofNullable(position));
    }

    public Optional<BlockPos> getWorkAreaPosition() {
        return (Optional)this.entityData.get(WORK_AREA_POSITION);
    }

    public void setWorkAreaPosition(BlockPos position) {
        this.entityData.set(WORK_AREA_POSITION, Optional.ofNullable(position));
        BrainUtils.setMemory((LivingEntity)this, OccultismMemoryTypes.WORK_AREA_CENTER.get(), (Object)this.getWorkAreaCenter());
        this.getJob().ifPresent(SpiritJob::onChangeWorkArea);
    }

    public WorkAreaSize getWorkAreaSize() {
        return WorkAreaSize.get((Integer)this.entityData.get(WORK_AREA_SIZE));
    }

    public void setWorkAreaSize(WorkAreaSize workAreaSize) {
        this.entityData.set(WORK_AREA_SIZE, (Object)workAreaSize.ordinal());
        BrainUtils.setMemory((LivingEntity)this, OccultismMemoryTypes.WORK_AREA_SIZE.get(), (Object)this.getWorkAreaSize().getValue());
        this.getJob().ifPresent(SpiritJob::onChangeWorkArea);
    }

    public BlockPos getWorkAreaCenter() {
        return this.getWorkAreaPosition().orElse(this.blockPosition());
    }

    public Direction getDepositFacing() {
        return (Direction)this.entityData.get(DEPOSIT_FACING);
    }

    public void setDepositFacing(Direction depositFacing) {
        this.entityData.set(DEPOSIT_FACING, (Object)depositFacing);
        BrainUtils.setMemory((LivingEntity)this, OccultismMemoryTypes.DEPOSIT_FACING.get(), (Object)depositFacing);
    }

    public Direction getExtractFacing() {
        return (Direction)this.entityData.get(EXTRACT_FACING);
    }

    public void setExtractFacing(Direction extractFacing) {
        this.entityData.set(EXTRACT_FACING, (Object)extractFacing);
    }

    public int getSpiritAge() {
        return (Integer)this.entityData.get(SPIRIT_AGE);
    }

    public void setSpiritAge(int seconds) {
        this.entityData.set(SPIRIT_AGE, (Object)seconds);
    }

    public int getSpiritMaxAge() {
        return (Integer)this.entityData.get(SPIRIT_MAX_AGE);
    }

    public void setSpiritMaxAge(int seconds) {
        this.entityData.set(SPIRIT_MAX_AGE, (Object)seconds);
    }

    public String getJobID() {
        return (String)this.entityData.get(JOB_ID);
    }

    public void setJobID(String id) {
        this.entityData.set(JOB_ID, (Object)id);
    }

    public boolean isFilterBlacklist() {
        return (Boolean)this.entityData.get(IS_FILTER_BLACKLIST);
    }

    public void setFilterBlacklist(boolean isFilterBlacklist) {
        this.entityData.set(IS_FILTER_BLACKLIST, (Object)isFilterBlacklist);
    }

    public String getTagFilter() {
        return (String)this.entityData.get(TAG_FILTER);
    }

    public void setTagFilter(String tagFilter) {
        this.entityData.set(TAG_FILTER, (Object)tagFilter);
    }

    public ItemStackHandler getFilterItems() {
        return this.filterItemStackHandler;
    }

    public Optional<SpiritJob> getJob() {
        if (this.job == null) {
            this.job = Optional.empty();
        }
        return this.job;
    }

    public void setJob(SpiritJob job) {
        this.setJob(job, true);
    }

    public void setJob(SpiritJob job, boolean recreateBrain) {
        this.removeJob();
        this.job = Optional.ofNullable(job);
        if (job != null) {
            this.job = Optional.ofNullable(job);
            this.setJobID(job.getFactoryID().toString());
            if (recreateBrain) {
                this.remakeBrain();
            }
        }
    }

    public void remakeBrain() {
        NbtOps nbtops = NbtOps.INSTANCE;
        this.brain = this.makeBrain(new Dynamic((DynamicOps)nbtops, (Object)((Tag)nbtops.createMap((Map)ImmutableMap.of((Object)nbtops.createString("memories"), (Object)((Tag)nbtops.emptyMap()))))));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new SpiritContainer(id, playerInventory, this);
    }

    @Override
    public LivingEntity getEntity() {
        return this;
    }

    @Override
    public EntityDataAccessor<Integer> getDataParameterSkin() {
        return SKIN;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.selectRandomSkin();
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageable) {
        return null;
    }

    public boolean shouldTryTeleportToOwner() {
        return false;
    }

    public void aiStep() {
        if (!this.level().isClientSide) {
            if (!this.isInitialized) {
                this.init();
            }
            if (this.level().getGameTime() % 20L == 0L && !this.dead && this.canDieFromAge()) {
                this.setSpiritAge(this.getSpiritAge() + 1);
                if (this.getSpiritAge() > this.getSpiritMaxAge()) {
                    this.die(this.damageSources().generic());
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
            if (!this.dead) {
                this.getJob().ifPresent(SpiritJob::update);
            }
        }
        this.updateSwingTime();
        super.aiStep();
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        return super.isInvulnerableTo(source) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.FLY_INTO_WALL);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.hurt(source, amount);
    }

    protected void registerGoals() {
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            return this.inventory.getStackInSlot(0);
        }
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            this.inventory.setStackInSlot(0, stack);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerSkinDataParameter(builder);
        builder.define(DEPOSIT_POSITION, Optional.empty());
        builder.define(DEPOSIT_ENTITY_UUID, Optional.empty());
        builder.define(DEPOSIT_FACING, (Object)Direction.UP);
        builder.define(EXTRACT_POSITION, Optional.empty());
        builder.define(EXTRACT_FACING, (Object)Direction.DOWN);
        builder.define(WORK_AREA_POSITION, Optional.empty());
        builder.define(WORK_AREA_SIZE, (Object)WorkAreaSize.SMALL.ordinal());
        builder.define(SPIRIT_AGE, (Object)0);
        builder.define(SPIRIT_MAX_AGE, (Object)-1);
        builder.define(JOB_ID, (Object)"");
        builder.define(IS_FILTER_BLACKLIST, (Object)false);
        builder.define(FILTER_ITEMS, (Object)new CompoundTag());
        builder.define(TAG_FILTER, (Object)"");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("spiritAge", this.getSpiritAge());
        compound.putInt("spiritMaxAge", this.getSpiritMaxAge());
        this.getWorkAreaPosition().ifPresent(pos -> compound.putLong("workAreaPosition", pos.asLong()));
        compound.putInt("workAreaSize", this.getWorkAreaSize().ordinal());
        this.getDepositPosition().ifPresent(pos -> compound.putLong("depositPosition", pos.asLong()));
        this.getDepositEntityUUID().ifPresent(uuid -> compound.putUUID("depositEntityUUID", uuid));
        compound.putInt("depositFacing", this.getDepositFacing().ordinal());
        this.getExtractPosition().ifPresent(pos -> compound.putLong("extractPosition", pos.asLong()));
        compound.putInt("extractFacing", this.getExtractFacing().ordinal());
        compound.put("inventory", (Tag)this.inventory.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
        this.getJob().ifPresent(job -> compound.put("spiritJob", (Tag)job.serializeNBT((HolderLookup.Provider)this.level().registryAccess())));
        compound.putBoolean("isFilterBlacklist", this.isFilterBlacklist());
        compound.put("filterItems", (Tag)this.filterItemStackHandler.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
        compound.putString("tagFilter", this.getTagFilter());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("spiritAge")) {
            this.setSpiritAge(compound.getInt("spiritAge"));
        }
        if (compound.contains("spiritMaxAge")) {
            this.setSpiritMaxAge(compound.getInt("spiritMaxAge"));
        }
        if (compound.contains("workAreaPosition")) {
            this.setWorkAreaPosition(BlockPos.of((long)compound.getLong("workAreaPosition")));
        }
        if (compound.contains("workAreaSize")) {
            this.setWorkAreaSize(WorkAreaSize.get(compound.getInt("workAreaSize")));
        }
        if (compound.contains("depositPosition")) {
            this.setDepositPosition(BlockPos.of((long)compound.getLong("depositPosition")));
        }
        if (compound.contains("depositEntityUUID")) {
            this.setDepositEntityUUID(compound.getUUID("depositEntityUUID"));
        }
        if (compound.contains("depositFacing")) {
            this.setDepositFacing(Direction.values()[compound.getInt("depositFacing")]);
        }
        if (compound.contains("extractPosition")) {
            this.setExtractPosition(BlockPos.of((long)compound.getLong("extractPosition")));
        }
        if (compound.contains("extractFacing")) {
            this.setExtractFacing(Direction.values()[compound.getInt("extractFacing")]);
        }
        if (compound.contains("inventory")) {
            this.inventory.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compound.getCompound("inventory"));
        }
        if (compound.contains("spiritJob")) {
            SpiritJob job = SpiritJob.from(this, compound.getCompound("spiritJob"));
            boolean containsBrain = compound.contains("Brain", 10);
            this.setJob(job, !containsBrain);
            if (compound.contains("Brain", 10)) {
                this.brain = this.makeBrain(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("Brain")));
            }
        }
        if (compound.contains("isFilterBlacklist")) {
            this.setFilterBlacklist(compound.getBoolean("isFilterBlacklist"));
        }
        if (compound.contains("filterItems")) {
            compound.getCompound("filterItems").putInt("Size", 14);
            this.filterItemStackHandler.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compound.getCompound("filterItems"));
        }
        if (compound.contains("tagFilter")) {
            this.setTagFilter(compound.getString("tagFilter"));
        }
    }

    public void setTame(boolean pTame, boolean pApplyTamingSideEffects) {
        super.setTame(pTame, pApplyTamingSideEffects);
        if (!pTame) {
            this.setJob(null);
        }
    }

    protected void dropEquipment() {
        super.dropEquipment();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            this.spawnAtLocation(itemstack, 0.0f);
        }
    }

    public void die(DamageSource cause) {
        if (!this.level().isClientSide) {
            if (this.isTame()) {
                BookOfCallingItem.spiritDeathRegister.put(this.uuid, this.level().getGameTime());
            }
            this.removeJob();
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.level().playSound(null, this.blockPosition(), OccultismSounds.START_RITUAL.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        super.die(cause);
    }

    public void remove(Entity.RemovalReason reason) {
        this.removeJob();
        super.remove(reason);
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!itemStack.is(OccultismTags.Items.BOOK_OF_CALLING_FOLIOT) && !itemStack.is(OccultismTags.Items.BOOK_OF_CALLING_DJINNI)) {
            if (!this.isTame()) {
                this.tame(player);
            }
            if (player.isShiftKeyDown() && this.getOwner() == player) {
                this.openScreen(player);
                return InteractionResult.SUCCESS;
            }
        }
        return super.interactAt(player, vec, hand);
    }

    public EntityDimensions getDefaultDimensions(Pose pPose) {
        return this.getJob().map(job -> job.getDimensions(pPose, super.getDefaultDimensions(pPose))).orElse(super.getDefaultDimensions(pPose));
    }

    public void removeJob() {
        this.getJob().ifPresent(SpiritJob::cleanup);
        this.job = Optional.empty();
    }

    public boolean canDieFromAge() {
        return (Integer)this.entityData.get(SPIRIT_MAX_AGE) > -1;
    }

    public void init() {
        this.isInitialized = true;
        this.getJob().ifPresent(SpiritJob::init);
    }

    public boolean canPickupItem(ItemEntity entity) {
        return this.getJob().map(job -> job.canPickupItem(entity)).orElse(false);
    }

    public void openScreen(Player playerEntity) {
        if (!this.level().isClientSide) {
            SpiritEntity menuProvider = this;
            SpiritJob currentJob = this.getJob().orElse(null);
            if (currentJob instanceof MenuProvider) {
                menuProvider = (MenuProvider)currentJob;
            }
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                serverPlayer.openMenu((MenuProvider)menuProvider, buf -> buf.writeInt(this.getId()));
            }
        }
    }
}

