/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.common.entity.ai.goal.PickupItemsGoal;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.crafting.recipe.SpiritTradeRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.phys.Vec3;

public class TraderJob
extends SpiritJob {
    protected int conversionTimer;
    protected int timeToConvert = 20;
    protected PickupItemsGoal pickupItemsGoal;
    protected RecipeHolder<SpiritTradeRecipe> trade;
    protected int maxTradesPerRound = 4;

    public TraderJob(SpiritEntity entity, ResourceLocation recipeId) {
        super(entity);
        this.setTradeRecipeId(recipeId);
    }

    public int getTimeToConvert() {
        return this.timeToConvert;
    }

    public void setTimeToConvert(int timeToConvert) {
        this.timeToConvert = timeToConvert;
    }

    public void setTradeRecipeId(ResourceLocation recipeId) {
        Optional recipe = this.entity.level().getRecipeManager().byKey(recipeId);
        this.trade = recipe.filter(r -> r.value() instanceof SpiritTradeRecipe).orElse(null);
    }

    public void setMaxTradesPerRound(int trades) {
        this.maxTradesPerRound = trades;
    }

    @Override
    public void onInit() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.targetSelector.addGoal(1, (Goal)this.pickupItemsGoal);
    }

    @Override
    public void cleanup() {
        this.entity.targetSelector.removeGoal((Goal)this.pickupItemsGoal);
    }

    @Override
    public void update() {
        ItemStack handHeld = this.entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.trade != null && ((SpiritTradeRecipe)this.trade.value()).isValid(handHeld)) {
            if (this.entity.level().getGameTime() % 10L == 0L) {
                Vec3 pos = this.entity.position();
                ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, pos.x + this.entity.level().random.nextGaussian() / 3.0, pos.y + 0.5, pos.z + this.entity.level().random.nextGaussian() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.entity.level().getGameTime() % 20L == 0L) {
                ++this.conversionTimer;
            }
            if (this.conversionTimer >= this.getTimeToConvert()) {
                int resultCount;
                this.conversionTimer = 0;
                List<ItemStack> input = Collections.singletonList(handHeld);
                for (resultCount = 0; ((SpiritTradeRecipe)this.trade.value()).isValid(input) && resultCount < this.maxTradesPerRound; ++resultCount) {
                    input = ((SpiritTradeRecipe)this.trade.value()).consume(input);
                }
                if (input.isEmpty()) {
                    this.entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                } else {
                    this.entity.setItemInHand(InteractionHand.MAIN_HAND, input.get(0));
                }
                ItemStack converted = ((SpiritTradeRecipe)this.trade.value()).getResultItem((HolderLookup.Provider)this.entity.level().registryAccess()).copy();
                converted.setCount(converted.getCount() * resultCount);
                if (resultCount > 0) {
                    this.entity.spawnAtLocation(converted, 0.0f);
                    this.onConvert(resultCount);
                }
            }
        } else {
            this.conversionTimer = 0;
        }
        super.update();
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("timeToConvert", this.timeToConvert);
        compound.putInt("conversionTimer", this.conversionTimer);
        compound.putInt("maxTradesPerRound", this.maxTradesPerRound);
        if (this.trade != null) {
            compound.putString("spiritTradeId", this.trade.id().toString());
        }
        return super.writeJobToNBT(compound, provider);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        super.readJobFromNBT(compound, provider);
        this.timeToConvert = compound.getInt("timeToConvert");
        this.conversionTimer = compound.getInt("conversionTimer");
        this.maxTradesPerRound = compound.getInt("maxTradesPerRound");
        if (compound.contains("spiritTradeId")) {
            this.setTradeRecipeId(ResourceLocation.parse((String)compound.getString("spiritTradeId")));
        }
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.getItem();
        return !stack.isEmpty() && ((SpiritTradeRecipe)this.trade.value()).isValid(stack);
    }

    public void onConvert(int count) {
    }
}

