/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.ai.goal.PickupItemsGoal;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.klikli_dev.occultism.crafting.recipe.TieredSingleRecipeInput;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityEvent;

public class CrusherJob
extends SpiritJob {
    public static final String DROPPED_BY_CRUSHER = "occultism:dropped_by_crusher";
    public static final String DROPPED_BY_SMELTER = "occultism:dropped_by_smelter";
    protected int crushingTimer;
    protected Supplier<Float> crushingTimeMultiplier;
    protected Supplier<Float> outputMultiplier;
    protected Supplier<Integer> tier;
    protected Optional<RecipeHolder<CrushingRecipe>> currentRecipe = Optional.empty();
    protected PickupItemsGoal pickupItemsGoal;
    protected List<Ingredient> itemsToPickUp = new ArrayList<Ingredient>();

    public CrusherJob(SpiritEntity entity, Supplier<Float> crushingTimeMultiplier, Supplier<Float> outputMultiplier, Supplier<Integer> tier) {
        super(entity);
        this.crushingTimeMultiplier = crushingTimeMultiplier;
        this.outputMultiplier = outputMultiplier;
        this.tier = tier;
    }

    @Override
    public void onInit() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.targetSelector.addGoal(1, (Goal)this.pickupItemsGoal);
        this.itemsToPickUp = this.entity.level().getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.CRUSHING_TYPE.get()).stream().filter(recipe -> {
            int minTier = ((CrushingRecipe)recipe.value()).getMinTier();
            int maxTier = ((CrushingRecipe)recipe.value()).getMaxTier();
            int currentTier = this.tier.get();
            return !(minTier >= 0 && minTier > currentTier || maxTier >= 0 && maxTier < currentTier);
        }).flatMap(recipe -> ((CrushingRecipe)recipe.value()).getIngredients().stream()).collect(Collectors.toList());
    }

    @Override
    public void cleanup() {
        this.entity.targetSelector.removeGoal((Goal)this.pickupItemsGoal);
    }

    @Override
    public void update() {
        ItemStack handHeld = this.entity.getItemInHand(InteractionHand.MAIN_HAND);
        TieredSingleRecipeInput recipeInput = new TieredSingleRecipeInput(handHeld, this.tier.get());
        if (!this.currentRecipe.isPresent() && !handHeld.isEmpty()) {
            this.currentRecipe = this.entity.level().getRecipeManager().getRecipeFor((RecipeType)OccultismRecipes.CRUSHING_TYPE.get(), (RecipeInput)recipeInput, this.entity.level());
            this.crushingTimer = 0;
            if (this.currentRecipe.isPresent()) {
                this.entity.level().playSound(null, this.entity.blockPosition(), OccultismSounds.CRUNCHING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.getRandom().nextFloat());
            } else {
                this.entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                ItemEntity droppedItem = this.entity.spawnAtLocation(handHeld);
                if (droppedItem != null) {
                    droppedItem.addTag(DROPPED_BY_CRUSHER);
                }
            }
        }
        if (this.currentRecipe.isPresent()) {
            if (handHeld.isEmpty() || !((CrushingRecipe)this.currentRecipe.get().value()).matches(recipeInput, this.entity.level())) {
                this.currentRecipe = Optional.empty();
            } else {
                ++this.crushingTimer;
                if (this.entity.level().getGameTime() % 10L == 0L) {
                    Vec3 pos = this.entity.position();
                    ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.CRIT, pos.x + this.entity.level().random.nextGaussian() / 3.0, pos.y + 0.5, pos.z + this.entity.level().random.nextGaussian() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.crushingTimer % 40 == 0) {
                    this.entity.level().playSound(null, this.entity.blockPosition(), OccultismSounds.CRUNCHING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.getRandom().nextFloat());
                }
                if ((float)this.crushingTimer >= (float)((CrushingRecipe)this.currentRecipe.get().value()).getCrushingTime() * this.crushingTimeMultiplier.get().floatValue()) {
                    ItemEntity droppedItem;
                    this.crushingTimer = 0;
                    ItemStack result = ((CrushingRecipe)this.currentRecipe.get().value()).assemble(recipeInput, (HolderLookup.Provider)this.entity.level().registryAccess());
                    float outputMultiplier = this.outputMultiplier.get().floatValue();
                    if (((CrushingRecipe)this.currentRecipe.get().value()).getIgnoreCrushingMultiplier()) {
                        outputMultiplier = 1.0f;
                    }
                    result.setCount((int)((float)result.getCount() * outputMultiplier));
                    ItemStack inputCopy = handHeld.copy();
                    inputCopy.setCount(1);
                    handHeld.shrink(1);
                    this.onCrush(inputCopy, result);
                    CrusherJobEvent event = new CrusherJobEvent((Entity)this.entity, inputCopy, result);
                    NeoForge.EVENT_BUS.post((Event)event);
                    if (!event.getResult().isEmpty() && (droppedItem = this.entity.spawnAtLocation(event.getResult())) != null) {
                        droppedItem.addTag(DROPPED_BY_CRUSHER);
                    }
                }
            }
        }
        super.update();
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("conversionTimer", this.crushingTimer);
        return super.writeJobToNBT(compound, provider);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        super.readJobFromNBT(compound, provider);
        this.crushingTimer = compound.getInt("conversionTimer");
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        if ((entity.getTags().contains(DROPPED_BY_CRUSHER) || entity.getTags().contains(DROPPED_BY_SMELTER)) && entity.getAge() < (Integer)Occultism.SERVER_CONFIG.spiritJobs.crusherResultPickupDelay.get()) {
            return false;
        }
        ItemStack stack = entity.getItem();
        return !stack.isEmpty() && this.itemsToPickUp.stream().anyMatch(i -> i.test(stack));
    }

    @Override
    public List<Ingredient> getItemsToPickUp() {
        return this.itemsToPickUp;
    }

    public void onCrush(ItemStack input, ItemStack output) {
    }

    public static class CrusherJobEvent
    extends EntityEvent {
        private ItemStack input;
        private ItemStack result;

        public CrusherJobEvent(Entity entity, ItemStack input, ItemStack result) {
            super(entity);
            this.input = input;
            this.result = result;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public void setInput(ItemStack input) {
            this.input = input;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }
    }
}

