/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.DevilFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class CthulhuFamiliarEntity
extends FamiliarEntity {
    private final WaterBoundPathNavigation waterNavigator;
    private final GroundPathNavigation groundNavigator;
    public float riderRot;
    public float riderRot0;
    public float riderLimbSwingAmount;
    public float riderLimbSwing;
    private BlockPos lightPos;
    private BlockPos lightPos0;
    private int lightTimer;

    public CthulhuFamiliarEntity(EntityType<? extends CthulhuFamiliarEntity> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.waterNavigator = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigator = new GroundPathNavigation((Mob)this, level);
        this.moveControl = new MoveController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return CthulhuFamiliarEntity.createMobAttributes().add(NeoForgeMod.SWIM_SPEED, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerWaterGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new GiveFlowerGoal(this));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasHat()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public void tick() {
        super.tick();
        if (this.isAngry() && this.getRandom().nextDouble() < 7.0E-4) {
            this.setAngry(false);
        }
        this.riderRot0 = this.riderRot;
        this.riderRot = Mth.approachDegrees((float)this.riderRot, (float)this.yRotO, (float)10.0f);
        if (!this.level().isClientSide) {
            --this.lightTimer;
            if (this.lightTimer < 0) {
                this.lightTimer = 10;
                if (this.lightPos == null) {
                    this.lightPos = this.blockPosition();
                }
                this.updateLight();
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setHat(this.getRandom().nextDouble() < 0.1);
        this.setTrunk(this.getRandom().nextDouble() < 0.5);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    protected void removeAfterChangingDimensions() {
        this.removeLight(this.lightPos);
        this.removeLight(this.lightPos0);
        this.lightPos = null;
        this.lightPos0 = null;
        super.removeAfterChangingDimensions();
    }

    private Vec3 riderLocation() {
        return Vec3.directionFromRotation((float)0.0f, (float)this.riderRot).yRot(230.0f).scale(0.68).add(this.position());
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public float getAnimationHeight(float partialTicks) {
        return Mth.cos((float)(((float)this.tickCount + partialTicks) / 5.0f));
    }

    public float riderRot(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.riderRot0, (float)this.riderRot);
    }

    private void updateLight() {
        this.removeLight(this.lightPos0);
        this.lightPos0 = null;
        if (this.lightPos != this.blockPosition()) {
            this.lightPos0 = this.lightPos;
            this.lightPos = this.blockPosition();
        }
        if (this.level().isEmptyBlock(this.lightPos) && this.isAlive() && this.hasBlacksmithUpgrade()) {
            this.level().setBlockAndUpdate(this.lightPos, ((Block)OccultismBlocks.LIGHTED_AIR.get()).defaultBlockState());
        }
    }

    private void removeLight(BlockPos pos) {
        if (!this.level().isClientSide && pos != null && this.level().getBlockState(pos).getBlock() == OccultismBlocks.LIGHTED_AIR.get()) {
            this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public void remove(Entity.RemovalReason reason) {
        this.removeLight(this.lightPos);
        this.removeLight(this.lightPos0);
        this.lightPos = null;
        this.lightPos0 = null;
        super.remove(reason);
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isInWater()) {
                this.navigation = this.waterNavigator;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigator;
                this.setSwimming(false);
            }
        }
    }

    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.hasPassenger(pPassenger)) {
            Vec3 direction = this.riderLocation();
            pCallback.accept(pPassenger, direction.x, direction.y, direction.z);
        }
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity pLivingEntity) {
        return this.riderLocation();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            if (source.getEntity() == this.getFamiliarOwner()) {
                this.setAngry(true);
                this.setSitting(true);
                ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(this.getFamiliarOwner(), FamiliarTrigger.Type.CTHULHU_SAD);
            } else if (source.getEntity() != null) {
                Vec3 tp = DefaultRandomPos.getPos((PathfinderMob)this, (int)8, (int)4);
                if (tp != null) {
                    this.absMoveTo(tp.x() + 0.5, tp.y(), tp.z() + 0.5, this.yRotO, this.xRotO);
                }
                this.navigation.stop();
            }
            return true;
        }
        return false;
    }

    public void die(DamageSource pCause) {
        this.removeLight(this.lightPos);
        this.removeLight(this.lightPos0);
        this.lightPos = null;
        this.lightPos0 = null;
        super.die(pCause);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(MobEffects.WATER_BREATHING, 300, 0, false, false));
    }

    public boolean hasHat() {
        return this.hasVariant(0);
    }

    private void setHat(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasTrunk() {
        return this.hasVariant(1);
    }

    private void setTrunk(boolean b) {
        this.setVariant(1, b);
    }

    public boolean isAngry() {
        return this.hasVariant(2);
    }

    private void setAngry(boolean b) {
        this.setVariant(2, b);
    }

    public boolean isGiving() {
        return this.hasVariant(3);
    }

    private void setGiving(boolean b) {
        this.setVariant(3, b);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (!compound.contains("variants")) {
            this.setHat(compound.getBoolean("hasHat"));
            this.setTrunk(compound.getBoolean("hasTrunk"));
            this.setAngry(compound.getBoolean("isAngry"));
        }
        if (compound.contains("lightPos")) {
            this.lightPos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"lightPos").get();
        }
        if (compound.contains("lightPos0")) {
            this.lightPos0 = (BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"lightPos0").get();
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.lightPos != null) {
            compound.put("lightPos", NbtUtils.writeBlockPos((BlockPos)this.lightPos));
        }
        if (this.lightPos0 != null) {
            compound.put("lightPos0", NbtUtils.writeBlockPos((BlockPos)this.lightPos0));
        }
    }

    public static class MoveController
    extends MoveControl {
        private final FamiliarEntity familiar;

        MoveController(FamiliarEntity familiar) {
            super((Mob)familiar);
            this.familiar = familiar;
        }

        public void tick() {
            if (this.familiar.isInWater()) {
                this.familiar.setDeltaMovement(this.familiar.getDeltaMovement().add(0.0, 0.005, 0.0));
                if (this.operation == MoveControl.Operation.MOVE_TO) {
                    float maxSpeed = (float)(this.speedModifier * this.familiar.getAttributeValue(Attributes.MOVEMENT_SPEED)) * 3.0f;
                    this.familiar.setSpeed(Mth.lerp((float)0.125f, (float)this.familiar.getSpeed(), (float)maxSpeed));
                    double dx = this.wantedX - this.familiar.getX();
                    double dy = this.wantedY - this.familiar.getY();
                    double dz = this.wantedZ - this.familiar.getZ();
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (distance < 0.1) {
                        this.familiar.setZza(0.0f);
                        return;
                    }
                    if (Math.abs(dy) > 1.0E-4) {
                        this.familiar.setDeltaMovement(this.familiar.getDeltaMovement().add(0.0, (double)this.familiar.getSpeed() * (dy / distance) * 0.1, 0.0));
                    }
                    if (Math.abs(dx) > 1.0E-4 || Math.abs(dz) > 1.0E-4) {
                        float rotate = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                        this.familiar.yBodyRot = this.familiar.yRotO = this.rotlerp(this.familiar.yRotO, rotate, 8.0f);
                    }
                } else {
                    this.familiar.setSpeed(0.0f);
                }
            } else {
                super.tick();
            }
        }
    }

    public static class FollowOwnerWaterGoal
    extends FamiliarEntity.FollowOwnerGoal {
        public FollowOwnerWaterGoal(FamiliarEntity entity, double speed, float minDist, float maxDist) {
            super(entity, speed, minDist, maxDist);
        }

        @Override
        protected boolean shouldTeleport(LivingEntity owner) {
            return !this.entity.level().isWaterAt(owner.blockPosition()) && this.entity.isInWater();
        }
    }

    private static class GiveFlowerGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 6000;
        private final CthulhuFamiliarEntity cthulhu;
        private DevilFamiliarEntity devil;
        private int cooldown = 6000;

        public GiveFlowerGoal(CthulhuFamiliarEntity cthulhu) {
            this.cthulhu = cthulhu;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.devil = this.findDevil();
            return this.devil != null && this.cooldown-- < 0 && this.cthulhu.distanceToSqr((Entity)this.devil) > 3.0 && !this.cthulhu.isVehicle();
        }

        public boolean canContinueToUse() {
            return this.devil != null && this.cthulhu.isPathFinding() && !this.cthulhu.isVehicle();
        }

        public void tick() {
            if (this.cthulhu.distanceToSqr((Entity)this.devil) < 2.0) {
                ((ServerLevel)this.cthulhu.level()).sendParticles((ParticleOptions)ParticleTypes.HEART, (double)this.devil.getBlockX(), (double)(this.devil.getBlockY() + 1), (double)this.devil.getBlockZ(), 1, 0.0, 0.0, 0.0, 1.0);
                this.devil = null;
            }
        }

        public void startExecuting() {
            this.cthulhu.getNavigation().moveTo((Entity)this.devil, 0.3);
            this.cthulhu.setGiving(true);
        }

        public void resetTask() {
            this.cthulhu.setGiving(false);
            this.cthulhu.getNavigation().stop();
            this.cooldown = 6000;
            this.devil = null;
        }

        private DevilFamiliarEntity findDevil() {
            List devils = this.cthulhu.level().getEntitiesOfClass(DevilFamiliarEntity.class, this.cthulhu.getBoundingBox().inflate(4.0));
            return devils.isEmpty() ? null : (DevilFamiliarEntity)devils.get(0);
        }
    }
}

