/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ReturnToWorkAreaGoal
extends Goal {
    protected final SpiritEntity entity;
    protected int executionChance;

    public ReturnToWorkAreaGoal(SpiritEntity entity) {
        this(entity, 10);
    }

    public ReturnToWorkAreaGoal(SpiritEntity entity, int executionChance) {
        this.entity = entity;
        this.executionChance = executionChance;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        long worldTime = this.entity.level().getGameTime() % 10L;
        if (this.entity.getNoActionTime() >= 100 && worldTime != 0L) {
            return false;
        }
        if (this.entity.getRandom().nextInt(this.executionChance) != 0 && worldTime != 0L) {
            return false;
        }
        return this.entity.getWorkAreaPosition().isPresent();
    }

    public void tick() {
        if (!this.entity.getWorkAreaPosition().isPresent()) {
            this.stop();
            this.entity.getNavigation().stop();
        } else {
            this.entity.getNavigation().moveTo(this.entity.getNavigation().createPath(this.entity.getWorkAreaPosition().orElse(this.entity.blockPosition()), 0), 1.0);
            double distance = this.entity.position().distanceTo(Vec3.atCenterOf((Vec3i)((Vec3i)this.entity.getWorkAreaPosition().orElse(this.entity.blockPosition()))));
            if (distance < 1.0) {
                this.entity.setDeltaMovement(0.0, 0.0, 0.0);
                this.entity.getNavigation().stop();
            }
        }
    }

    public boolean canContinueToUse() {
        return !this.entity.getNavigation().isDone();
    }

    public void start() {
        this.entity.getNavigation().moveTo(this.entity.getNavigation().createPath(this.entity.getWorkAreaPosition().orElse(this.entity.blockPosition()), 0), 1.0);
        super.start();
    }
}

