/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.ai.behaviour.ReplantSaplingBehaviour;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSelectBlock;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.util.StorageUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetToReplantSaplingBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of(OccultismMemoryTypes.LAST_FELLED_TREE.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return StorageUtil.getFirstMatchingSlot((IItemHandler)((SpiritEntity)entity).inventory, (TagKey<Item>)ItemTags.SAPLINGS) != -1;
    }

    protected void start(E entity) {
        BlockPos treePos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get());
        if (entity.distanceToSqr(Vec3.atCenterOf((Vec3i)treePos)) < ReplantSaplingBehaviour.REPLANT_RANGE_SQUARE) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
        } else {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(treePos));
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(treePos, 1.0f, 0));
            if (Occultism.DEBUG.debugAI) {
                Networking.sendToTracking(entity, new MessageSelectBlock(treePos, 5000, 65280));
            }
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

