/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.spirit;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismContainers;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SpiritContainer
extends AbstractContainerMenu {
    public ItemStackHandler inventory;
    public SpiritEntity spirit;

    public SpiritContainer(int id, Inventory playerInventory, SpiritEntity spirit) {
        this(OccultismContainers.SPIRIT.get(), id, playerInventory, spirit);
    }

    public SpiritContainer(@Nullable MenuType<?> type, int id, Inventory playerInventory, SpiritEntity spirit) {
        super(type, id);
        this.inventory = spirit.inventory;
        this.spirit = spirit;
        this.setupSlots(playerInventory);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= this.slots.size() - this.inventory.getSlots() ? !this.moveItemStackTo(itemstack1, 0, this.slots.size() - this.inventory.getSlots(), true) : !this.moveItemStackTo(itemstack1, this.slots.size() - this.inventory.getSlots(), this.slots.size(), true)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
    }

    public boolean stillValid(Player entityPlayer) {
        return this.spirit.isAlive() && this.spirit.distanceTo((Entity)entityPlayer) < 8.0f;
    }

    public void setupSlots(Inventory playerInventory) {
        this.setupPlayerInventorySlots(playerInventory.player);
        this.setupPlayerHotbar(playerInventory.player);
        this.setupEntityInventory();
    }

    protected void setupPlayerInventorySlots(Player player) {
        int playerInventoryTop = 84;
        int playerInventoryLeft = 8;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player.getInventory(), j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar(Player player) {
        int hotbarTop = 142;
        int hotbarLeft = 8;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)player.getInventory(), i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected void setupEntityInventory() {
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 0, 152, 54){

            public boolean mayPlace(ItemStack stack) {
                return super.mayPlace(stack);
            }

            public void setChanged() {
                this.container.setChanged();
            }
        });
    }
}

